/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util.problem;

import java.io.PrintStream;
import org.jsmiparser.util.location.Location;
import org.jsmiparser.util.problem.AbstractProblemEventHandler;
import org.jsmiparser.util.problem.ProblemEvent;

public class DefaultProblemEventHandler
extends AbstractProblemEventHandler {
    private PrintStream m_out;
    private PrintStream m_err;

    public DefaultProblemEventHandler() {
        this.m_out = System.out;
        this.m_err = System.err;
    }

    public DefaultProblemEventHandler(PrintStream out, PrintStream err) {
        this.m_out = out;
        this.m_err = err;
    }

    public void handle(ProblemEvent event) {
        super.handle(event);
        switch (event.getSeverity()) {
            case ERROR: {
                this.error(event.getLocation(), event.getLocalizedMessage());
                break;
            }
            case FATAL: {
                this.error(event.getLocation(), event.getLocalizedMessage());
                break;
            }
            case WARNING: {
                this.warning(event.getLocation(), event.getLocalizedMessage());
            }
        }
    }

    private void error(Location location, String localizedMessage) {
        this.print(this.m_err, "Error", location, localizedMessage);
    }

    private void warning(Location location, String localizedMessage) {
        this.print(this.m_out, "Warning", location, localizedMessage);
    }

    private void print(PrintStream stream, String sev, Location location, String localizedMessage) {
        String loc = location != null ? location.toString() : null;
        stream.println(sev + ": file://" + loc + " :" + localizedMessage);
    }
}

