/*
 * Decompiled with CFR 0.152.
 */
package org.jsmiparser.util.url;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jsmiparser.util.url.AbstractURLListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathURLListFactory
extends AbstractURLListFactory {
    protected ClassLoader m_classLoader;

    public ClassPathURLListFactory() {
    }

    public ClassPathURLListFactory(String rootPath) {
        super(rootPath);
    }

    public ClassPathURLListFactory(String rootPath, List<String> children) {
        super(rootPath, children);
    }

    public ClassLoader getClassLoader() {
        if (this.m_classLoader != null) {
            return this.m_classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }

    @Override
    public List<URL> create() {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String child : this.m_children) {
            String path = this.getRootPath();
            if (!path.isEmpty() && !path.endsWith("/")) {
                path = path + "/";
            }
            path = path + child;
            ClassLoader classLoader = this.getClassLoader();
            URL url = classLoader.getResource(path);
            if (url == null) {
                throw new IllegalStateException("Classpath resource doesn't exist (perhaps you are missing a slash at the end or have one too much at the beginning?): " + path);
            }
            result.add(url);
        }
        return result;
    }
}

