/*
 * Decompiled with CFR 0.152.
 */
package org.jsqrl.model;

import java.util.Map;
import java.util.stream.Stream;
import org.jsqrl.model.TransactionInformationFlag;
import org.jsqrl.util.SqrlUtil;

public class SqrlAuthResponse {
    private static final String LINE_SEPARATOR = "\r\n";
    private String ver;
    private String nut;
    private int tif = 0;
    private String qry;
    private String url;
    private String suk;
    private String ask;
    private Map<String, String> additionalData;

    public String toString() {
        StringBuilder sqrlResponseStringBuilder = new StringBuilder("");
        sqrlResponseStringBuilder.append("ver=").append(this.ver).append(LINE_SEPARATOR).append("nut=").append(this.nut).append(LINE_SEPARATOR).append("tif=").append(this.tif).append(LINE_SEPARATOR).append("qry=").append(this.qry);
        this.appendKeyValuePairIfExists(sqrlResponseStringBuilder, "url", this.url);
        this.appendKeyValuePairIfExists(sqrlResponseStringBuilder, "suk", this.suk);
        this.appendKeyValuePairIfExists(sqrlResponseStringBuilder, "ask", this.ask);
        if (this.additionalData != null) {
            this.additionalData.keySet().stream().forEach(k -> this.appendKeyValuePairIfExists(sqrlResponseStringBuilder, (String)k, this.additionalData.get(k)));
        }
        return sqrlResponseStringBuilder.toString();
    }

    public String toEncodedString() {
        return SqrlUtil.unpaddedBase64UrlEncoded(this.toString());
    }

    private StringBuilder appendKeyValuePairIfExists(StringBuilder builder, String key, String value) {
        if (value != null) {
            builder.append(LINE_SEPARATOR).append(key).append("=").append(value);
        }
        return builder;
    }

    public void addAsk(String message, String button1, String button2) {
        this.ask = SqrlUtil.unpaddedBase64UrlEncoded(message) + "~" + SqrlUtil.unpaddedBase64UrlEncoded(button1) + "~" + SqrlUtil.unpaddedBase64UrlEncoded(button2);
    }

    SqrlAuthResponse(String ver, String nut, int tif, String qry, String url, String suk, String ask, Map<String, String> additionalData) {
        this.ver = ver;
        this.nut = nut;
        this.tif = tif;
        this.qry = qry;
        this.url = url;
        this.suk = suk;
        this.ask = ask;
        this.additionalData = additionalData;
    }

    public static SqrlAuthResponseBuilder builder() {
        return new SqrlAuthResponseBuilder();
    }

    public String getVer() {
        return this.ver;
    }

    public String getNut() {
        return this.nut;
    }

    public int getTif() {
        return this.tif;
    }

    public String getQry() {
        return this.qry;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSuk() {
        return this.suk;
    }

    public String getAsk() {
        return this.ask;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public static class SqrlAuthResponseBuilder {
        private String ver;
        private String nut;
        private int tif;
        private String qry;
        private String url;
        private String suk;
        private String ask;
        private Map<String, String> additionalData;

        public SqrlAuthResponseBuilder addTifs(TransactionInformationFlag ... tifs) {
            Stream.of(tifs).forEach(t -> this.tif |= t.getHexValue());
            return this;
        }

        SqrlAuthResponseBuilder() {
        }

        public SqrlAuthResponseBuilder ver(String ver) {
            this.ver = ver;
            return this;
        }

        public SqrlAuthResponseBuilder nut(String nut) {
            this.nut = nut;
            return this;
        }

        public SqrlAuthResponseBuilder tif(int tif) {
            this.tif = tif;
            return this;
        }

        public SqrlAuthResponseBuilder qry(String qry) {
            this.qry = qry;
            return this;
        }

        public SqrlAuthResponseBuilder url(String url) {
            this.url = url;
            return this;
        }

        public SqrlAuthResponseBuilder suk(String suk) {
            this.suk = suk;
            return this;
        }

        public SqrlAuthResponseBuilder ask(String ask) {
            this.ask = ask;
            return this;
        }

        public SqrlAuthResponseBuilder additionalData(Map<String, String> additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        public SqrlAuthResponse build() {
            return new SqrlAuthResponse(this.ver, this.nut, this.tif, this.qry, this.url, this.suk, this.ask, this.additionalData);
        }

        public String toString() {
            return "SqrlAuthResponse.SqrlAuthResponseBuilder(ver=" + this.ver + ", nut=" + this.nut + ", tif=" + this.tif + ", qry=" + this.qry + ", url=" + this.url + ", suk=" + this.suk + ", ask=" + this.ask + ", additionalData=" + this.additionalData + ")";
        }
    }
}

