/*
 * Decompiled with CFR 0.152.
 */
package org.jsqrl.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsqrl.model.SqrlCommand;
import org.jsqrl.model.SqrlOptionFlag;
import org.jsqrl.util.SqrlUtil;

public class SqrlClientRequest {
    private static final String REQUEST_VERSION = "ver";
    private static final String COMMAND = "cmd";
    private static final String OPTIONS = "opt";
    private static final String IDENTITY_KEY = "idk";
    private static final String PREVIOUS_IDENTITY_KEY = "pidk";
    private static final String SERVER_UNLOCK_KEY = "suk";
    private static final String VERIFY_UNLOCK_KEY = "vuk";
    private static final String BUTTON = "btn";
    private String client;
    private String server;
    private String ids;
    private String pids;
    private String urs;
    private Map<String, String> clientParameters;
    private Map<String, String> serverParameters;
    private Set<SqrlOptionFlag> optionFlags;

    public void setClient(String client) {
        this.client = client;
        this.clientParameters = this.parseParameterString(new String(SqrlUtil.base64UrlDecode(client)));
        this.optionFlags = this.parseOptionFlags(this.clientParameters);
    }

    public String getClientParameter(String parameter) {
        return this.clientParameters != null ? this.clientParameters.get(parameter) : null;
    }

    public String getIdentityKey() {
        return this.getClientParameter(IDENTITY_KEY);
    }

    public String getPreviousIdentityKey() {
        return this.getClientParameter(PREVIOUS_IDENTITY_KEY);
    }

    public String getServerUnlockKey() {
        return this.getClientParameter(SERVER_UNLOCK_KEY);
    }

    public String getVerifyUnlockKey() {
        return this.getClientParameter(VERIFY_UNLOCK_KEY);
    }

    public String getRequestVersion() {
        return this.getClientParameter(REQUEST_VERSION);
    }

    public String getButton() {
        return this.getClientParameter(BUTTON);
    }

    public SqrlCommand getCommand() {
        return SqrlCommand.from(this.getClientParameter(COMMAND));
    }

    public String getDecodedClientData() {
        return new String(SqrlUtil.base64UrlDecode(this.client));
    }

    public String getDecodedServerData() {
        return new String(SqrlUtil.base64UrlDecode(this.server));
    }

    public byte[] getDecodedIdentitySignature() {
        return this.getDecodedSignature(this.ids);
    }

    public byte[] getDecodedPreviousIdSignature() {
        return this.getDecodedSignature(this.pids);
    }

    public byte[] getDecodedUnlockRequestSignature() {
        return this.getDecodedSignature(this.urs);
    }

    private byte[] getDecodedSignature(String signature) {
        if (signature != null) {
            return SqrlUtil.base64UrlDecode(signature);
        }
        return null;
    }

    private Map<String, String> parseParameterString(String decodedString) {
        if (decodedString == null) {
            return new HashMap<String, String>();
        }
        String[] keyValuePairs = decodedString.split("\r\n");
        return Stream.of(keyValuePairs).map(v -> v.split("=")).filter(v -> v != null && ((String[])v).length > 1).collect(Collectors.toMap(k -> k[0], v -> v[1]));
    }

    private Set<SqrlOptionFlag> parseOptionFlags(Map<String, String> clientParameters) {
        String optionString = clientParameters.get(OPTIONS);
        return optionString == null || "".equals(optionString) ? new HashSet<SqrlOptionFlag>() : Stream.of(optionString.split("~")).map(SqrlOptionFlag::from).filter(o -> o != null).collect(Collectors.toSet());
    }

    public String getClient() {
        return this.client;
    }

    public String getServer() {
        return this.server;
    }

    public String getIds() {
        return this.ids;
    }

    public String getPids() {
        return this.pids;
    }

    public String getUrs() {
        return this.urs;
    }

    public Map<String, String> getClientParameters() {
        return this.clientParameters;
    }

    public Map<String, String> getServerParameters() {
        return this.serverParameters;
    }

    public Set<SqrlOptionFlag> getOptionFlags() {
        return this.optionFlags;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public void setPids(String pids) {
        this.pids = pids;
    }

    public void setUrs(String urs) {
        this.urs = urs;
    }

    public void setClientParameters(Map<String, String> clientParameters) {
        this.clientParameters = clientParameters;
    }

    public void setServerParameters(Map<String, String> serverParameters) {
        this.serverParameters = serverParameters;
    }

    public void setOptionFlags(Set<SqrlOptionFlag> optionFlags) {
        this.optionFlags = optionFlags;
    }
}

