/*
 * Decompiled with CFR 0.152.
 */
package org.jsqrl.nut;

import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.jsqrl.error.SqrlException;

public class SqrlNut {
    private byte[] hashedIp;
    private int count;
    private int random;
    private boolean qr;
    private LocalDateTime created;

    public SqrlNut(byte[] hashedIp, int count, int random, boolean qr) {
        this.hashedIp = hashedIp;
        this.count = count;
        this.random = random;
        this.qr = qr;
        this.created = LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    public SqrlNut(int count, int random, boolean qr) {
        this(null, count, random, qr);
    }

    public SqrlNut(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new SqrlException("Invalid nut bytes provided");
        }
        this.hashedIp = Arrays.copyOfRange(bytes, 0, 4);
        ByteBuffer tsBuffer = ByteBuffer.wrap(Arrays.copyOfRange(bytes, 4, 8));
        Integer timestamp = tsBuffer.getInt();
        this.created = LocalDateTime.ofEpochSecond(timestamp.longValue(), 0, ZoneOffset.UTC);
        ByteBuffer countBuffer = ByteBuffer.wrap(Arrays.copyOfRange(bytes, 8, 12));
        this.count = countBuffer.getInt();
        ByteBuffer noiseBuffer = ByteBuffer.wrap(Arrays.copyOfRange(bytes, 12, 16));
        this.random = noiseBuffer.getInt();
        this.qr = this.random % 2 != 0;
    }

    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        if (this.hashedIp != null && this.hashedIp.length > 3) {
            byteBuffer.put(this.hashedIp[this.hashedIp.length - 4]);
            byteBuffer.put(this.hashedIp[this.hashedIp.length - 3]);
            byteBuffer.put(this.hashedIp[this.hashedIp.length - 2]);
            byteBuffer.put(this.hashedIp[this.hashedIp.length - 1]);
        } else {
            byteBuffer.putInt(0);
        }
        Long timestamp = this.created.toEpochSecond(ZoneOffset.UTC);
        byteBuffer.putInt(timestamp.intValue());
        byteBuffer.putInt(this.count);
        int noise = this.random << 1;
        if (this.qr) {
            ++noise;
        }
        byteBuffer.putInt(noise);
        return byteBuffer.array();
    }

    public Boolean checkIpMatch(SqrlNut otherNut) {
        return otherNut != null ? this.checkIpMatch(otherNut.getHashedIp()) : false;
    }

    public Boolean checkIpMatch(byte[] otherHashedIp) {
        boolean match = false;
        if (otherHashedIp != null && otherHashedIp.length >= 4) {
            for (int i = 1; i <= 4; ++i) {
                if (this.hashedIp[this.hashedIp.length - i] == otherHashedIp[otherHashedIp.length - i]) continue;
                return false;
            }
            match = true;
        }
        return match;
    }

    public byte[] getHashedIp() {
        return this.hashedIp;
    }

    public int getCount() {
        return this.count;
    }

    public int getRandom() {
        return this.random;
    }

    public boolean isQr() {
        return this.qr;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public String toString() {
        return "SqrlNut(hashedIp=" + Arrays.toString(this.getHashedIp()) + ", count=" + this.getCount() + ", random=" + this.getRandom() + ", qr=" + this.isQr() + ", created=" + this.getCreated() + ")";
    }
}

