/*
 * Decompiled with CFR 0.152.
 */
package org.jsqrl.service;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jsqrl.config.SqrlConfig;
import org.jsqrl.error.SqrlException;
import org.jsqrl.nut.SqrlNut;
import org.jsqrl.util.SqrlUtil;

public class SqrlNutService {
    private final Random rng;
    private final SqrlConfig config;
    private final MessageDigest hasher;
    private final Key serverEncryptionKey;
    private Integer count;

    public SqrlNutService(Random rng, SqrlConfig config, MessageDigest hasher, Key serverEncryptionKey) {
        this.rng = rng;
        this.config = config;
        this.hasher = hasher;
        this.serverEncryptionKey = serverEncryptionKey;
        this.count = 0;
    }

    public SqrlNut createNut(String ipAddress, boolean qr) {
        int random = this.rng.nextInt();
        Integer n = this.count;
        Integer n2 = this.count = Integer.valueOf(this.count + 1);
        if (ipAddress == null) {
            return new SqrlNut(this.count, random, qr);
        }
        return new SqrlNut(this.hasher.digest(ipAddress.getBytes()), this.count, random, qr);
    }

    public Boolean nutBelongsToIp(String nutString, String ipAddress) {
        SqrlNut nut = this.createNutFromString(nutString);
        return nut.checkIpMatch(this.hasher.digest(ipAddress.getBytes()));
    }

    public String getNutString(SqrlNut sqrlNut) {
        try {
            Cipher cipher = this.getCipher(1);
            byte[] encrypted = cipher.doFinal(sqrlNut.toByteArray());
            return SqrlUtil.unpaddedBase64UrlEncoded(encrypted);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SqrlException("Error creating encrypted and encoded nut string", e);
        }
    }

    public SqrlNut createNutFromString(String encryptedAndEncodedNut) {
        byte[] decodedEncryptedString = SqrlUtil.base64UrlDecode(encryptedAndEncodedNut);
        try {
            byte[] decrypted = this.getCipher(2).doFinal(decodedEncryptedString);
            if (decrypted.length >= 16) {
                return new SqrlNut(decrypted);
            }
            throw new SqrlException("Invalid nut receieved");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new SqrlException("Error decrypting nut string", e);
        }
    }

    private Cipher getCipher(int encryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(encryptMode, this.serverEncryptionKey);
        return cipher;
    }
}

