/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jtb.quickr.AuthCheckTokenRequest;
import org.jtb.quickr.AuthGetFrobRequest;
import org.jtb.quickr.AuthGetTokenRequest;
import org.jtb.quickr.AuthResponse;
import org.jtb.quickr.AuthUrl;
import org.jtb.quickr.FrobResponse;
import org.jtb.quickr.Permissions;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.Service;

public class AuthService
extends Service {
    private static Logger logger = Logger.getLogger((String)AuthService.class.getName());

    public AuthService() throws QuickrException {
    }

    public AuthService(Properties properties) throws QuickrException {
        super(properties);
    }

    public FrobResponse getFrob() throws QuickrException {
        AuthGetFrobRequest gfreq = new AuthGetFrobRequest(this.properties.getRestUrl(), this.properties.getApiKey(), this.properties.getSecret());
        FrobResponse frob = gfreq.execute();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("frob: " + frob));
        }
        return frob;
    }

    public URL getAuthUrl(FrobResponse frob, Permissions perms) throws QuickrException {
        AuthUrl furl = new AuthUrl(this.properties.getAuthUrl(), this.properties.getApiKey(), this.properties.getSecret(), frob, perms);
        return furl.getUrl();
    }

    public AuthResponse getToken(FrobResponse frob) throws QuickrException {
        if (frob == null) {
            throw new NullPointerException("frob cannot be null");
        }
        AuthGetTokenRequest gtreq = new AuthGetTokenRequest(this.properties.getRestUrl(), this.properties.getApiKey(), this.properties.getSecret(), frob);
        AuthResponse ares = gtreq.execute();
        return ares;
    }

    public AuthResponse checkToken(AuthResponse.Token authToken) throws QuickrException {
        AuthCheckTokenRequest ctreq = new AuthCheckTokenRequest(this.properties.getRestUrl(), this.properties.getApiKey(), this.properties.getSecret(), authToken);
        AuthResponse ares = ctreq.execute();
        return ares;
    }
}

