/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jtb.quickr.FlickrResponse;
import org.jtb.quickr.QuickrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactsResponse
extends FlickrResponse {
    private static Logger logger = Logger.getLogger((String)ContactsResponse.class.getName());
    private int page;
    private int pages;
    private int perPage;
    private int total;
    private List<Contact> contacts;

    ContactsResponse(InputStream is) throws QuickrException {
        this.init(is);
    }

    @Override
    protected void populate(Element e) throws QuickrException {
        Element contactsElement = e.getChild("contacts");
        this.page = ContactsResponse.getAttrInt(contactsElement, "page");
        this.pages = ContactsResponse.getAttrInt(contactsElement, "pages");
        this.perPage = ContactsResponse.getAttrInt(contactsElement, "per_page");
        this.total = ContactsResponse.getAttrInt(contactsElement, "total");
        this.contacts = new ArrayList<Contact>();
        List contactElements = contactsElement.getChildren("contact");
        if (ContactsResponse.getLogger().isDebugEnabled()) {
            ContactsResponse.getLogger().debug((Object)("number of contacts: " + contactElements.size()));
        }
        for (Element contactElement : contactElements) {
            Contact c = new Contact(contactElement);
            this.contacts.add(c);
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public int getPage() {
        return this.page;
    }

    public int getPages() {
        return this.pages;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getTotal() {
        return this.total;
    }

    public List<Contact> getContacts() {
        return Collections.unmodifiableList(this.contacts);
    }

    public static class Contact
    extends FlickrResponse {
        private String nsId;
        private String userName;
        private String realName;
        private String iconServer;
        private String iconFarm;
        private Boolean friend;
        private Boolean family;
        private Boolean ignored;

        Contact(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            this.nsId = e.getAttributeValue("nsid");
            this.userName = e.getAttributeValue("username");
            this.realName = e.getAttributeValue("realname");
            this.iconServer = e.getAttributeValue("iconserver");
            this.iconFarm = e.getAttributeValue("iconfarm");
            this.family = Contact.getAttrBoolean(e, "family");
            this.friend = Contact.getAttrBoolean(e, "friend");
            this.ignored = Contact.getAttrBoolean(e, "ignored");
        }

        public String getIconFarm() {
            return this.iconFarm;
        }
    }
}

