/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jtb.quickr.BooleanInt;
import org.jtb.quickr.FlickrResponseException;
import org.jtb.quickr.QuickrException;

public abstract class FlickrResponse {
    protected FlickrResponse() {
    }

    protected FlickrResponse(InputStream is) throws QuickrException {
        if (is == null) {
            throw new NullPointerException("stream can not be null");
        }
        this.init(is);
    }

    protected FlickrResponse(Element e) throws QuickrException {
        if (e == null) {
            throw new NullPointerException("element cannot be null");
        }
        this.populate(e);
    }

    protected void init(InputStream is) throws QuickrException {
        try {
            SAXBuilder sb = new SAXBuilder();
            Document d = sb.build(is);
            Element e = d.detachRootElement();
            this.checkStatus(e);
            this.populate(e);
        }
        catch (JDOMException je) {
            throw new QuickrException("could not build response document", je);
        }
        catch (IOException ioe) {
            throw new QuickrException("could not build response document", ioe);
        }
    }

    private void checkStatus(Element e) throws FlickrResponseException {
        Status status = new Status(e.getAttributeValue("stat"));
        if (!status.equals(Status.OK)) {
            Element errElement = e.getChild("err");
            if (errElement == null) {
                throw new FlickrResponseException("flickr error", status);
            }
            ErrorCode errorCode = new ErrorCode(errElement.getAttributeValue("code"));
            String errorMessage = errElement.getAttributeValue("msg");
            throw new FlickrResponseException("flickr error", status, errorCode, errorMessage);
        }
    }

    protected static String getBodyString(Element parentElement, String tagName) {
        Element childElement = parentElement.getChild(tagName);
        if (childElement == null) {
            return null;
        }
        return childElement.getTextTrim();
    }

    protected static String getBodyString(Element element) {
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    protected static int getBodyInt(Element parentElement, String tagName) {
        Element childElement = parentElement.getChild(tagName);
        if (childElement == null) {
            return 0;
        }
        return Integer.valueOf(childElement.getTextTrim());
    }

    protected static boolean getAttrBoolean(Element e, String attrName) {
        String val = e.getAttributeValue(attrName);
        if (val == null) {
            return false;
        }
        BooleanInt bi = new BooleanInt(val);
        return bi.booleanValue();
    }

    protected static int getAttrInt(Element e, String attrName) {
        String val = e.getAttributeValue(attrName);
        if (val == null) {
            return 0;
        }
        return Integer.valueOf(val);
    }

    protected static Date getAttrDate(Element e, String attrName) {
        String val = e.getAttributeValue(attrName);
        if (val == null) {
            return null;
        }
        return new Date(Long.valueOf(val) * 1000L);
    }

    protected abstract void populate(Element var1) throws QuickrException;

    public static class ErrorCode {
        public static final ErrorCode INVALID_SIGNATURE = new ErrorCode("96");
        public static final ErrorCode INVALID_AUTH_TOKEN = new ErrorCode("98");
        public static final ErrorCode INSUFFICIENT_PERMISSION = new ErrorCode("99");
        public static final ErrorCode INVALID_API_KEY = new ErrorCode("100");
        public static final ErrorCode SERVICE_UNAVAILABLE = new ErrorCode("105");
        public static final ErrorCode FORMAT_NOT_FOUND = new ErrorCode("111");
        public static final ErrorCode METHOD_NOT_FOUND = new ErrorCode("112");
        private String code;

        ErrorCode(String code) {
            this.code = code;
        }

        public String toString() {
            return this.code;
        }

        public boolean equals(Object o) {
            ErrorCode ec = (ErrorCode)o;
            return this.toString().equals(ec.toString());
        }
    }

    public static class Status {
        public static final Status OK = new Status("ok");
        public static final Status FAIL = new Status("fail");
        private String statusString;

        Status(String statusString) {
            this.statusString = statusString;
        }

        public String toString() {
            return this.statusString;
        }

        public boolean equals(Object o) {
            Status s = (Status)o;
            return this.toString().equals(s.toString());
        }
    }
}

