/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.log4j.Logger;
import org.jtb.quickr.HttpVerb;
import org.jtb.quickr.QuickrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultipartPost
extends HttpVerb {
    static Logger logger = Logger.getLogger((String)MultipartPost.class.getName());
    private Map<String, Object> data;

    public MultipartPost(URL url, Map<String, Object> data) throws QuickrException {
        super(url);
        this.data = data;
    }

    private RequestEntity getRequestEntity(PostMethod postMethod, Map<String, Object> data) throws QuickrException {
        ArrayList<StringPart> parts = new ArrayList<StringPart>();
        for (String key : data.keySet()) {
            StringPart part;
            Object val = data.get(key);
            if (val instanceof String) {
                part = new StringPart(key, (String)val);
            } else if (val instanceof File) {
                try {
                    part = new FilePart(key, (File)val);
                }
                catch (FileNotFoundException fnfe) {
                    throw new QuickrException("file not found for part key: " + key + ", val: " + val, fnfe);
                }
            } else {
                throw new QuickrException("unknown data type, key: " + val.getClass().getName() + " for key: " + key);
            }
            parts.add(part);
        }
        Collections.sort(parts, new PartComparator());
        MultipartRequestEntity requestEntity = new MultipartRequestEntity(parts.toArray(new Part[0]), postMethod.getParams());
        if (logger.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                requestEntity.writeRequest((OutputStream)baos);
                logger.debug((Object)("upload request entity is:\n" + baos.toString()));
            }
            catch (IOException ioe) {
                throw new QuickrException("could not debug request entity", ioe);
            }
        }
        return requestEntity;
    }

    @Override
    public InputStream execute() throws QuickrException {
        PostMethod postMethod = new PostMethod(this.getUrl().toString());
        RequestEntity requestEntity = this.getRequestEntity(postMethod, this.data);
        postMethod.setRequestEntity(requestEntity);
        InputStream is = null;
        HttpClient httpClient = this.getHttpClient();
        try {
            int status = httpClient.executeMethod((HttpMethod)postMethod);
            if (status != 200) {
                throw new QuickrException("post failed, status: " + status);
            }
            if (logger.isDebugEnabled()) {
                String response = postMethod.getResponseBodyAsString();
                logger.debug((Object)("upload response:\n" + response));
            }
            is = postMethod.getResponseBodyAsStream();
        }
        catch (IOException ioe) {
            throw new QuickrException("could not post to URL: " + this.getUrl());
        }
        return is;
    }

    private static class PartComparator
    implements Comparator {
        private PartComparator() {
        }

        public int compare(Object o1, Object o2) {
            Part p1 = (Part)o1;
            Part p2 = (Part)o2;
            return p1.getName().compareTo(p2.getName());
        }
    }
}

