/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jtb.quickr.Get;
import org.jtb.quickr.MethodRequest;
import org.jtb.quickr.PersonResponse;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.ServiceMethodUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PeopleGetInfoRequest
extends MethodRequest {
    private static Logger logger = Logger.getLogger((String)PeopleGetInfoRequest.class.getName());
    private String nsId;

    protected PeopleGetInfoRequest(String baseUrl, String apiKey, String nsid) throws QuickrException {
        super(baseUrl, apiKey, "flickr.people.getInfo");
        this.nsId = nsid;
    }

    @Override
    protected Map<String, String> getArgs() {
        this.putArg("user_id", this.getNsid());
        return super.getArgs();
    }

    @Override
    public PersonResponse execute() throws QuickrException {
        ServiceMethodUrl furl = new ServiceMethodUrl(this.getBaseUrl(), this.getArgs(), this.getApiKey(), this.getMethod());
        Get get = new Get(furl.getUrl());
        InputStream is = get.execute();
        PersonResponse pres = new PersonResponse(is);
        return pres;
    }

    protected String getNsid() {
        return this.nsId;
    }
}

