/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdom.Element;
import org.jtb.quickr.FlickrResponse;
import org.jtb.quickr.QuickrException;

public class PersonResponse
extends FlickrResponse {
    private String nsId;
    private boolean isAdmin;
    private boolean isPro;
    private String iconServer;
    private String userName;
    private String realName;
    private String mboxSha1Sum;
    private String location;
    private URL photosUrl;
    private URL profileUrl;
    private Photos photos;

    PersonResponse(InputStream is) throws QuickrException {
        super(is);
    }

    protected void populate(Element e) throws QuickrException {
        String location;
        String mboxSha1Sum;
        String realName;
        this.nsId = e.getAttributeValue("nsid");
        this.isAdmin = Boolean.valueOf(e.getAttributeValue("isadmin"));
        this.isPro = Boolean.valueOf(e.getAttributeValue("ispro"));
        this.iconServer = e.getAttributeValue("iconserver");
        String userName = PersonResponse.getBodyString(e, "username");
        if (userName != null) {
            this.userName = userName;
        }
        if ((realName = PersonResponse.getBodyString(e, "realname")) != null) {
            this.realName = realName;
        }
        if ((mboxSha1Sum = PersonResponse.getBodyString(e, "mbox_sha1sum")) != null) {
            this.mboxSha1Sum = mboxSha1Sum;
        }
        if ((location = PersonResponse.getBodyString(e, "location")) != null) {
            this.location = location;
        }
        try {
            String profileUrlString;
            String photosUrlString = PersonResponse.getBodyString(e, "photosurl");
            if (photosUrlString != null) {
                this.photosUrl = new URL(photosUrlString);
            }
            if ((profileUrlString = PersonResponse.getBodyString(e, "profileurl")) != null) {
                this.profileUrl = new URL(profileUrlString);
            }
        }
        catch (MalformedURLException mfue) {
            // empty catch block
        }
        Element photosElement = e.getChild("photos");
        if (photosElement != null) {
            this.photos = new Photos(photosElement);
        }
    }

    private static class Photos
    extends FlickrResponse {
        private long firstDate;
        private String firstDateTaken;
        private int count;

        public Photos(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            String countString;
            String firstDateTaken;
            String firstDateString = Photos.getBodyString(e, "firstdate");
            if (firstDateString != null) {
                this.firstDate = Long.valueOf(firstDateString);
            }
            if ((firstDateTaken = Photos.getBodyString(e, "firstdatetaken")) != null) {
                this.firstDateTaken = firstDateTaken;
            }
            if ((countString = Photos.getBodyString(e, "count")) != null) {
                this.count = Integer.valueOf(countString);
            }
        }
    }
}

