/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jtb.quickr.FlickrResponse;
import org.jtb.quickr.PhotoSize;
import org.jtb.quickr.PhotoUrl;
import org.jtb.quickr.QuickrException;

public class PhotoResponse
extends FlickrResponse {
    private static Logger logger = Logger.getLogger((String)PhotoResponse.class.getName());
    private String photoId;
    private String photoSecret;
    private String server;
    private boolean favorite;
    private String license;
    private int rotation;
    private String originalFormat;
    private Owner owner;
    private String description;
    private Visibility visibility;
    private Dates dates;
    private Permissions permissions;
    private Editability editability;
    private int comments;
    private Notes notes;
    private Tags tags;
    private Urls urls;
    private String staticUrl;

    PhotoResponse(InputStream is, String staticUrl) throws QuickrException {
        this.staticUrl = staticUrl;
        this.init(is);
    }

    protected void populate(Element e) throws QuickrException {
        Element photoElement = e.getChild("photo");
        this.photoId = photoElement.getAttributeValue("id");
        this.photoSecret = photoElement.getAttributeValue("secret");
        this.server = photoElement.getAttributeValue("server");
        this.favorite = PhotoResponse.getAttrBoolean(photoElement, "favorite");
        this.license = photoElement.getAttributeValue("license");
        this.rotation = PhotoResponse.getAttrInt(photoElement, "rotation");
        this.originalFormat = photoElement.getAttributeValue("originalformat");
        this.description = PhotoResponse.getBodyString(photoElement, "description");
        this.comments = PhotoResponse.getBodyInt(photoElement, "comments");
        this.owner = new Owner(photoElement);
        this.visibility = new Visibility(photoElement);
        this.dates = new Dates(photoElement);
        this.permissions = new Permissions(photoElement);
        this.editability = new Editability(photoElement);
        this.notes = new Notes(photoElement);
        this.tags = new Tags(photoElement);
        this.urls = new Urls(photoElement);
    }

    public String getPhotoId() {
        return this.photoId;
    }

    public String getPhotoSecret() {
        return this.photoSecret;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public String getLicense() {
        return this.license;
    }

    public int getRotation() {
        return this.rotation;
    }

    public String getOriginalFormat() {
        return this.originalFormat;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public String getDescription() {
        return this.description;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Dates getDates() {
        return this.dates;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public Editability getEditability() {
        return this.editability;
    }

    public int getComments() {
        return this.comments;
    }

    public Notes getNotes() {
        return this.notes;
    }

    public Tags getTags() {
        return this.tags;
    }

    public Urls getUrls() {
        return this.urls;
    }

    public URL getUrl(PhotoSize size) throws QuickrException {
        PhotoUrl purl = new PhotoUrl(this.staticUrl, this.getServer(), this.getPhotoId(), this.getPhotoSecret(), size);
        return purl.getUrl();
    }

    public URL getThumbnailUrl() throws QuickrException {
        return this.getUrl(PhotoSize.THUMBNAIL);
    }

    public URL getSmallSquareUrl() throws QuickrException {
        return this.getUrl(PhotoSize.SMALL_SQUARE);
    }

    public URL getSmallUrl() throws QuickrException {
        return this.getUrl(PhotoSize.SMALL);
    }

    public URL getMediumUrl() throws QuickrException {
        return this.getUrl(PhotoSize.MEDIUM);
    }

    public URL getLargeUrl() throws QuickrException {
        return this.getUrl(PhotoSize.LARGE);
    }

    public URL getOriginalUrl() throws QuickrException {
        PhotoUrl purl = new PhotoUrl(this.staticUrl, this.getServer(), this.getPhotoId(), this.getPhotoSecret(), this.getOriginalFormat());
        return purl.getUrl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Urls
    extends FlickrResponse {
        private List<Url> urls;

        Urls(Element e) throws QuickrException {
            super(e);
        }

        @Override
        protected void populate(Element e) throws QuickrException {
            Element ue = e.getChild("urls");
            this.urls = new ArrayList<Url>();
            List urlElements = ue.getChildren("url");
            for (Element urlElement : urlElements) {
                Url u = new Url(urlElement);
                this.urls.add(u);
            }
        }

        public List<Url> getUrls() {
            return this.urls;
        }

        public static class Url
        extends FlickrResponse {
            private String type;
            private URL url;

            Url(Element e) throws QuickrException {
                super(e);
            }

            protected void populate(Element e) throws QuickrException {
                this.type = e.getAttributeValue("type");
                try {
                    this.url = new URL(Url.getBodyString(e));
                }
                catch (MalformedURLException mfue) {
                    throw new QuickrException("could not construct URL: " + Url.getBodyString(e));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tags
    extends FlickrResponse {
        private List<Tag> tags;

        Tags(Element e) throws QuickrException {
            super(e);
        }

        @Override
        protected void populate(Element e) throws QuickrException {
            Element te = e.getChild("tags");
            this.tags = new ArrayList<Tag>();
            List tagElements = te.getChildren("tag");
            for (Element tagElement : tagElements) {
                Tag t = new Tag(tagElement);
                this.tags.add(t);
            }
        }

        public List<Tag> getTags() {
            return this.tags;
        }

        public static class Tag
        extends FlickrResponse {
            private String id;
            private String author;
            private String raw;
            private String tag;

            Tag(Element e) throws QuickrException {
                super(e);
            }

            protected void populate(Element e) {
                this.id = e.getAttributeValue("id");
                this.author = e.getAttributeValue("author");
                this.raw = e.getAttributeValue("raw");
                this.tag = Tag.getBodyString(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Notes
    extends FlickrResponse {
        private List<Note> notes;

        Notes(Element e) throws QuickrException {
            super(e);
        }

        @Override
        protected void populate(Element e) throws QuickrException {
            Element ne = e.getChild("notes");
            this.notes = new ArrayList<Note>();
            List noteElements = ne.getChildren("note");
            for (Element noteElement : noteElements) {
                Note n = new Note(noteElement);
                this.getNotes().add(n);
            }
        }

        public List<Note> getNotes() {
            return this.notes;
        }

        public static class Note
        extends FlickrResponse {
            private String id;
            private String author;
            private String authorName;
            private int x;
            private int y;
            private int w;
            private int h;
            private String note;

            Note(Element e) throws QuickrException {
                super(e);
            }

            protected void populate(Element e) throws QuickrException {
                this.id = e.getAttributeValue("id");
                this.author = e.getAttributeValue("author");
                this.authorName = e.getAttributeValue("authorname");
                this.x = Note.getAttrInt(e, "x");
                this.y = Note.getAttrInt(e, "y");
                this.w = Note.getAttrInt(e, "w");
                this.h = Note.getAttrInt(e, "h");
                this.note = Note.getBodyString(e);
            }

            public String getId() {
                return this.id;
            }

            public String getAuthor() {
                return this.author;
            }

            public String getAuthorName() {
                return this.authorName;
            }

            public int getX() {
                return this.x;
            }

            public int getY() {
                return this.y;
            }

            public int getW() {
                return this.w;
            }

            public int getH() {
                return this.h;
            }

            public String getNote() {
                return this.note;
            }
        }
    }

    public static class Editability
    extends FlickrResponse {
        private boolean canComment;
        private boolean canAddMeta;

        Editability(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            Element ee = e.getChild("editability");
            this.canComment = Editability.getAttrBoolean(ee, "cancomment");
            this.canAddMeta = Editability.getAttrBoolean(ee, "canaddmeta");
        }

        public boolean isCanComment() {
            return this.canComment;
        }

        public boolean isCanAddMeta() {
            return this.canAddMeta;
        }
    }

    public static class Permissions
    extends FlickrResponse {
        private int comment = 0;
        private int addMeta = 0;

        Permissions(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            Element pe = e.getChild("permissions");
            if (pe == null) {
                return;
            }
            this.comment = Permissions.getAttrInt(pe, "permcomment");
            this.addMeta = Permissions.getAttrInt(pe, "permaddmeta");
        }

        public int getComment() {
            return this.comment;
        }

        public int getAddMeta() {
            return this.addMeta;
        }
    }

    public static class Dates
    extends FlickrResponse {
        private Date posted;
        private String taken;
        private int takenGranularity;
        private Date lastUpdate;

        Dates(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            Element oe = e.getChild("dates");
            this.posted = Dates.getAttrDate(oe, "posted");
            this.taken = oe.getAttributeValue("taken");
            this.takenGranularity = Dates.getAttrInt(oe, "takengranularity");
            this.lastUpdate = Dates.getAttrDate(oe, "lastupdate");
        }

        public Date getPosted() {
            return this.posted;
        }

        public String getTaken() {
            return this.taken;
        }

        public int getTakenGranularity() {
            return this.takenGranularity;
        }

        public Date getLastUpdate() {
            return this.lastUpdate;
        }
    }

    public static class Visibility
    extends FlickrResponse {
        private boolean pub;
        private boolean friend;
        private boolean family;

        Visibility(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            Element ve = e.getChild("visibility");
            this.pub = Visibility.getAttrBoolean(ve, "ispublic");
            this.friend = Visibility.getAttrBoolean(ve, "isfriend");
            this.family = Visibility.getAttrBoolean(ve, "isfamily");
        }

        public boolean isPub() {
            return this.pub;
        }

        public boolean isFriend() {
            return this.friend;
        }

        public boolean isFamily() {
            return this.family;
        }
    }

    public static class Owner
    extends FlickrResponse {
        private String userId;
        private String userName;
        private String realName;
        private String location;

        Owner(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            Element ownerElement = e.getChild("owner");
            this.userId = ownerElement.getAttributeValue("nsid");
            this.userName = ownerElement.getAttributeValue("username");
            this.realName = ownerElement.getAttributeValue("realname");
            this.location = ownerElement.getAttributeValue("location");
        }

        public String getUserId() {
            return this.userId;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getRealName() {
            return this.realName;
        }

        public String getLocation() {
            return this.location;
        }
    }
}

