/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jtb.quickr.FlickrUrl;
import org.jtb.quickr.PhotoSize;
import org.jtb.quickr.QuickrException;

class PhotoUrl
extends FlickrUrl {
    private static Logger logger = Logger.getLogger((String)PhotoUrl.class.getName());
    private String serverId;
    private String photoId;
    private String secret;
    private PhotoSize size;
    private String ext;

    public PhotoUrl(String staticUrl, String serverId, String photoId, String secret, PhotoSize size) throws QuickrException {
        this(staticUrl, serverId, photoId, secret, size, "jpg");
    }

    PhotoUrl(String staticUrl, String serverId, String photoId, String secret, String ext) throws QuickrException {
        this(staticUrl, serverId, photoId, secret, PhotoSize.ORIGINAL, ext);
    }

    PhotoUrl(String staticUrl, String serverId, String photoId, String secret, PhotoSize size, String ext) throws QuickrException {
        super(staticUrl);
        this.serverId = serverId;
        this.photoId = photoId;
        this.secret = secret;
        this.size = size;
        this.ext = ext;
    }

    protected URL buildUrl() throws QuickrException {
        StringBuffer b = new StringBuffer(32);
        b.append(this.getBaseUrl());
        b.append("/");
        b.append(this.serverId);
        b.append("/");
        b.append(this.photoId);
        b.append("_");
        b.append(this.secret);
        if (!this.size.equals(PhotoSize.MEDIUM)) {
            b.append("_");
            b.append(this.size.toString());
        }
        b.append(".");
        b.append(this.ext);
        try {
            URL url = new URL(b.toString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("url: " + url));
            }
            return url;
        }
        catch (MalformedURLException mfue) {
            throw new QuickrException("could not construct photo URL", mfue);
        }
    }
}

