/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.Map;
import org.jtb.quickr.AuthResponse;
import org.jtb.quickr.Get;
import org.jtb.quickr.PhotosResponse;
import org.jtb.quickr.PhotosSearchCriteria;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.SignedMethodRequest;
import org.jtb.quickr.SignedMethodUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PhotosSearchRequest
extends SignedMethodRequest {
    private String staticUrl;
    private PhotosSearchCriteria photoSearchArgs;

    protected PhotosSearchRequest(String baseUrl, String apiKey, String secret, AuthResponse.Token authToken, PhotosSearchCriteria photoSearchArgs, String staticUrl) throws QuickrException {
        super(baseUrl, apiKey, secret, authToken, "flickr.photos.search");
        this.photoSearchArgs = photoSearchArgs;
        this.staticUrl = staticUrl;
    }

    @Override
    protected Map<String, String> getArgs() {
        PhotosSearchCriteria psa = this.photoSearchArgs;
        if (psa.getUserId() != null) {
            this.putArg("user_id", psa.getUserId());
        }
        if (psa.getTags() != null && psa.getTags().size() > 0) {
            this.putArg("tags", PhotosSearchRequest.join(psa.getTags(), ','));
        }
        if (psa.getTagMode() != null) {
            this.putArg("tag_mode", psa.getTagMode().toString());
        }
        if (psa.getText() != null) {
            this.putArg("text", psa.getText());
        }
        if (psa.getMinUploadDate() != null) {
            this.putArg("min_upload_date", Long.toString(psa.getMinUploadDate().getTime()));
        }
        if (psa.getMaxUploadDate() != null) {
            this.putArg("max_upload_date", Long.toString(psa.getMaxUploadDate().getTime()));
        }
        if (psa.getMinTakenDate() != null) {
            this.putArg("min_taken_date", Long.toString(psa.getMinTakenDate().getTime()));
        }
        if (psa.getMaxTakenDate() != null) {
            this.putArg("max_taken_date", Long.toString(psa.getMaxTakenDate().getTime()));
        }
        if (psa.getLicenses() != null && psa.getLicenses().size() > 0) {
            this.putArg("license", PhotosSearchRequest.join(psa.getLicenses(), ','));
        }
        if (psa.getSort() != null) {
            this.putArg("sort", psa.getSort().toString());
        }
        if (psa.getPrivacyFilter() != null) {
            this.putArg("privacy_filter", psa.getPrivacyFilter().toString());
        }
        if (psa.getBoundingBox() != null) {
            this.putArg("bbox", psa.getBoundingBox().toString());
        }
        if (psa.getLocationAccuracy() != null) {
            this.putArg("accuracy", psa.getLocationAccuracy().toString());
        }
        if (psa.getExtras() != null && psa.getExtras().size() > 0) {
            this.putArg("extras", PhotosSearchRequest.join(psa.getExtras(), ','));
        }
        if (psa.getPerPage() != null) {
            this.putArg("per_page", psa.getPerPage().toString());
        }
        if (psa.getPage() != null) {
            this.putArg("page", psa.getPage().toString());
        }
        return super.getArgs();
    }

    @Override
    public PhotosResponse execute() throws QuickrException {
        SignedMethodUrl furl = new SignedMethodUrl(this.getBaseUrl(), this.getArgs(), this.getApiKey(), this.getSecret(), this.getAuthToken(), this.getMethod());
        Get get = new Get(furl.getUrl());
        InputStream is = get.execute();
        PhotosResponse pres = new PhotosResponse(is, this.staticUrl);
        return pres;
    }
}

