/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApiSignature {
    private static Logger logger = Logger.getLogger((String)ApiSignature.class.getName());
    private String signature;

    public ApiSignature(String secret, Map<String, String> args) {
        this.setSignature(ApiSignature.buildSignature(secret, args));
    }

    private static String buildSignature(String secret, Map<String, String> args) {
        StringBuffer b = new StringBuffer(32);
        b.append(secret);
        TreeMap<String, String> sargs = new TreeMap<String, String>(args);
        for (String key : sargs.keySet()) {
            String val = (String)sargs.get(key);
            b.append(key);
            b.append(val);
        }
        String s = b.toString();
        String sig = DigestUtils.md5Hex((String)s);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("string to sign: " + s));
            logger.debug((Object)("signature: " + sig));
        }
        return sig;
    }

    public String getSignature() {
        return this.signature;
    }

    private void setSignature(String signature) {
        this.signature = signature;
    }
}

