/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import org.jdom.Element;
import org.jtb.quickr.FlickrResponse;
import org.jtb.quickr.QuickrException;

public class AuthResponse
extends FlickrResponse {
    private Token authToken;
    private String perms;
    private User user;

    AuthResponse(InputStream is) throws QuickrException {
        super(is);
    }

    protected void populate(Element e) throws QuickrException {
        Element authElement = e.getChild("auth");
        if (authElement != null) {
            Element userElement;
            Element permsElement;
            Element tokenElement = authElement.getChild("token");
            if (tokenElement != null) {
                this.setAuthToken(new Token(tokenElement.getText()));
            }
            if ((permsElement = authElement.getChild("perms")) != null) {
                this.setPerms(permsElement.getText());
            }
            if ((userElement = authElement.getChild("user")) != null) {
                this.setAuthUser(new User(userElement));
            }
        }
    }

    public Token getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(Token authToken) {
        this.authToken = authToken;
    }

    public String getPerms() {
        return this.perms;
    }

    public void setPerms(String perms) {
        this.perms = perms;
    }

    public User getAuthUser() {
        return this.user;
    }

    public void setAuthUser(User authUser) {
        this.user = authUser;
    }

    public static class User
    extends FlickrResponse {
        private String nsId;
        private String userName;
        private String fullName;

        User(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            this.setNsId(e.getAttributeValue("nsid"));
            this.setUserName(e.getAttributeValue("username"));
            this.setFullName(e.getAttributeValue("fullname"));
        }

        public String getNsId() {
            return this.nsId;
        }

        private void setNsId(String nsId) {
            this.nsId = nsId;
        }

        public String getUserName() {
            return this.userName;
        }

        private void setUserName(String userName) {
            this.userName = userName;
        }

        public String getFullName() {
            return this.fullName;
        }

        private void setFullName(String fullName) {
            this.fullName = fullName;
        }
    }

    public static class Token {
        private String tokenString;

        public Token(String tokenString) {
            this.tokenString = tokenString;
        }

        public String toString() {
            return this.tokenString;
        }
    }
}

