/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.Map;
import org.jtb.quickr.AuthResponse;
import org.jtb.quickr.ContactsGetListCriteria;
import org.jtb.quickr.ContactsResponse;
import org.jtb.quickr.Get;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.SignedMethodRequest;
import org.jtb.quickr.SignedMethodUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContactsGetListRequest
extends SignedMethodRequest {
    private ContactsGetListCriteria getListCriteria;
    private String staticUrl;

    protected ContactsGetListRequest(String baseUrl, String apiKey, String secret, AuthResponse.Token authToken, ContactsGetListCriteria getListCriteria, String staticUrl) throws QuickrException {
        super(baseUrl, apiKey, secret, authToken, "flickr.contacts.getList");
        this.getListCriteria = getListCriteria;
        this.staticUrl = staticUrl;
    }

    @Override
    protected Map<String, String> getArgs() {
        if (this.getListCriteria.getFilter() != null) {
            this.putArg("filter", this.getListCriteria.getFilter().toString());
        }
        if (this.getListCriteria.getPage() != null) {
            this.putArg("page", this.getListCriteria.getPage().toString());
        }
        if (this.getListCriteria.getPerPage() != null) {
            this.putArg("per_page", this.getListCriteria.getPerPage().toString());
        }
        return super.getArgs();
    }

    @Override
    public ContactsResponse execute() throws QuickrException {
        SignedMethodUrl furl = new SignedMethodUrl(this.getBaseUrl(), this.getArgs(), this.getApiKey(), this.getSecret(), this.getAuthToken(), this.getMethod());
        Get get = new Get(furl.getUrl());
        InputStream is = get.execute();
        ContactsResponse cres = new ContactsResponse(is, this.staticUrl);
        return cres;
    }
}

