/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.Map;
import org.jtb.quickr.ContactsGetPublicListCriteria;
import org.jtb.quickr.ContactsResponse;
import org.jtb.quickr.Get;
import org.jtb.quickr.MethodRequest;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.ServiceMethodUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContactsGetPublicListRequest
extends MethodRequest {
    private ContactsGetPublicListCriteria criteria;
    private String staticUrl;

    protected ContactsGetPublicListRequest(String baseUrl, String apiKey, ContactsGetPublicListCriteria criteria, String staticUrl) throws QuickrException {
        super(baseUrl, apiKey, "flickr.contacts.getPublicList");
        this.criteria = criteria;
        this.staticUrl = staticUrl;
    }

    @Override
    protected Map<String, String> getArgs() {
        if (this.criteria.getUserId() != null) {
            this.putArg("user_id", this.criteria.getUserId());
        }
        if (this.criteria.getPage() != null) {
            this.putArg("page", this.criteria.getPage().toString());
        }
        if (this.criteria.getPerPage() != null) {
            this.putArg("per_page", this.criteria.getPerPage().toString());
        }
        return super.getArgs();
    }

    @Override
    public ContactsResponse execute() throws QuickrException {
        ServiceMethodUrl furl = new ServiceMethodUrl(this.getBaseUrl(), this.getArgs(), this.getApiKey(), this.getMethod());
        Get get = new Get(furl.getUrl());
        InputStream is = get.execute();
        ContactsResponse cres = new ContactsResponse(is, this.staticUrl);
        return cres;
    }
}

