/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jtb.quickr.FlickrResponse;
import org.jtb.quickr.QuickrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FlickrRequest {
    private String baseUrl;
    private String apiKey;
    private Map<String, String> args;

    public FlickrRequest(String baseUrl, String apiKey) {
        this.setBaseUrl(baseUrl);
        this.setApiKey(apiKey);
        this.args = new HashMap<String, String>();
    }

    public abstract FlickrResponse execute() throws QuickrException;

    protected String getBaseUrl() {
        return this.baseUrl;
    }

    private void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected String getApiKey() {
        return this.apiKey;
    }

    private void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    protected Map<String, String> getArgs() {
        this.putArg("api_key", this.getApiKey());
        return Collections.unmodifiableMap(this.args);
    }

    protected void putArg(String key, String val) {
        if (key == null) {
            throw new NullPointerException("null key not allowed");
        }
        if (val == null) {
            return;
        }
        this.args.put(key, val);
    }

    protected static String join(Set set, char c) {
        if (set == null) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            b.append(i.next().toString());
            if (!i.hasNext()) continue;
            b.append(c);
        }
        return b.toString();
    }
}

