/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jtb.quickr.QuickrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlickrUrl {
    private static Logger logger = Logger.getLogger((String)FlickrUrl.class.getName());
    private URL url;
    private String baseUrl;
    private Map<String, String> args;

    public FlickrUrl(String baseUrl) {
        this(baseUrl, new HashMap<String, String>());
    }

    public FlickrUrl(String serviceUrl, Map<String, String> args) {
        this.setBaseUrl(serviceUrl);
        this.setArgs(new HashMap<String, String>(args));
    }

    protected URL buildUrl() throws QuickrException {
        Map<String, String> args = this.getArgs();
        StringBuffer u = new StringBuffer(32);
        u.append(this.getBaseUrl());
        if (args.size() > 0) {
            u.append("?");
        }
        Iterator<String> i = args.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next();
            String val = args.get(key);
            u.append(key);
            u.append("=");
            u.append(val);
            if (!i.hasNext()) continue;
            u.append("&");
        }
        try {
            URL url = new URL(u.toString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("url: " + url));
            }
            return url;
        }
        catch (MalformedURLException mfue) {
            mfue.printStackTrace();
            throw new QuickrException("could not create URL", mfue);
        }
    }

    public URL getUrl() throws QuickrException {
        if (this.url == null) {
            this.url = this.buildUrl();
        }
        return this.url;
    }

    public String toString() {
        try {
            return this.getUrl().toString();
        }
        catch (QuickrException qe) {
            throw new RuntimeException(qe);
        }
    }

    protected String getBaseUrl() {
        return this.baseUrl;
    }

    private void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected Map<String, String> getArgs() {
        return Collections.unmodifiableMap(this.args);
    }

    protected void putArg(String key, String val) {
        this.args.put(key, val);
    }

    private void setArgs(Map<String, String> args) {
        this.args = args;
    }
}

