/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.log4j.Logger;
import org.jtb.quickr.QuickrException;

abstract class HttpVerb {
    static Logger logger = Logger.getLogger((String)HttpVerb.class.getName());
    private URL url;

    public HttpVerb(URL url) {
        this.setUrl(url);
    }

    public abstract InputStream execute() throws QuickrException;

    protected URL getUrl() {
        return this.url;
    }

    private void setUrl(URL url) {
        this.url = url;
    }

    protected HttpClient getHttpClient() {
        HttpClient httpClient = new HttpClient();
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null) {
            int proxyPort = 80;
            String pp = System.getProperty("http.proxyPort");
            if (pp != null) {
                proxyPort = Integer.parseInt(pp);
            }
            httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("using proxy: " + proxyHost + ":" + proxyPort));
            }
        }
        return httpClient;
    }
}

