/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.Map;
import org.jtb.quickr.Get;
import org.jtb.quickr.MethodRequest;
import org.jtb.quickr.PhotoResponse;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.ServiceMethodUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PhotosGetInfoRequest
extends MethodRequest {
    private String staticUrl;
    private String photoId;
    private String photoSecret;

    protected PhotosGetInfoRequest(String baseUrl, String apiKey, String photoId, String photoSecret, String staticUrl) throws QuickrException {
        super(baseUrl, apiKey, "flickr.photos.getInfo");
        this.photoId = photoId;
        this.photoSecret = photoSecret;
        this.staticUrl = staticUrl;
    }

    @Override
    protected Map<String, String> getArgs() {
        this.putArg("photo_id", this.photoId);
        if (this.photoSecret != null) {
            this.putArg("secret", this.photoSecret);
        }
        return super.getArgs();
    }

    @Override
    public PhotoResponse execute() throws QuickrException {
        ServiceMethodUrl furl = new ServiceMethodUrl(this.getBaseUrl(), this.getArgs(), this.getApiKey(), this.getMethod());
        Get get = new Get(furl.getUrl());
        InputStream is = get.execute();
        PhotoResponse pres = new PhotoResponse(is, this.staticUrl);
        return pres;
    }
}

