/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jtb.quickr.FlickrResponse;
import org.jtb.quickr.PhotoSize;
import org.jtb.quickr.PhotoUrl;
import org.jtb.quickr.QuickrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotosResponse
extends FlickrResponse {
    private static Logger logger = Logger.getLogger((String)PhotosResponse.class.getName());
    private static final int SHORT_TITLE_LENGTH = 7;
    private static final String ELLIPSIS = "...";
    private int page;
    private int pages;
    private int perPage;
    private int total;
    private List<Photo> photos;
    private String staticUrl;

    PhotosResponse(InputStream is, String staticUrl) throws QuickrException {
        this.staticUrl = staticUrl;
        this.init(is);
    }

    @Override
    protected void populate(Element e) throws QuickrException {
        Element photosElement = e.getChild("photos");
        this.page = PhotosResponse.getAttrInt(photosElement, "page");
        this.pages = PhotosResponse.getAttrInt(photosElement, "pages");
        this.perPage = PhotosResponse.getAttrInt(photosElement, "perpage");
        this.total = PhotosResponse.getAttrInt(photosElement, "total");
        this.photos = new ArrayList<Photo>();
        List photoElements = photosElement.getChildren("photo");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("number of photos: " + photoElements.size()));
        }
        for (Element photoElement : photoElements) {
            Photo p = new Photo(photoElement, this.staticUrl);
            this.photos.add(p);
        }
    }

    public List<Photo> getPhotos() {
        return this.photos;
    }

    private void setPhotos(List<Photo> photos) {
        this.photos = photos;
    }

    public int getPage() {
        return this.page;
    }

    public int getPages() {
        return this.pages;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getTotal() {
        return this.total;
    }

    public static class Photo
    extends FlickrResponse {
        private String photoId;
        private String owner;
        private String photoSecret;
        private String server;
        private String title;
        private String shortTitle;
        private boolean publicAccessible;
        private boolean friendAccessible;
        private boolean familyAccessible;
        private String staticUrl;

        Photo(Element e, String staticUrl) throws QuickrException {
            super(e);
            this.staticUrl = staticUrl;
        }

        protected void populate(Element e) {
            this.publicAccessible = Photo.getAttrBoolean(e, "ispublic");
            this.friendAccessible = Photo.getAttrBoolean(e, "isfriend");
            this.familyAccessible = Photo.getAttrBoolean(e, "isfamily");
            this.photoId = e.getAttributeValue("id");
            this.owner = e.getAttributeValue("owner");
            this.photoSecret = e.getAttributeValue("secret");
            this.server = e.getAttributeValue("server");
            this.title = e.getAttributeValue("title");
            this.shortTitle = this.title.length() > 7 + PhotosResponse.ELLIPSIS.length() ? this.title.substring(0, 7) + PhotosResponse.ELLIPSIS : this.title;
        }

        public URL getUrl(PhotoSize size) throws QuickrException {
            PhotoUrl purl = new PhotoUrl(this.getStaticUrl(), this.getServer(), this.getPhotoId(), this.getPhotoSecret(), size);
            return purl.getUrl();
        }

        public URL getThumbnailUrl() throws QuickrException {
            return this.getUrl(PhotoSize.THUMBNAIL);
        }

        public URL getSmallSquareUrl() throws QuickrException {
            return this.getUrl(PhotoSize.SMALL_SQUARE);
        }

        public URL getSmallUrl() throws QuickrException {
            return this.getUrl(PhotoSize.SMALL);
        }

        public URL getMediumUrl() throws QuickrException {
            return this.getUrl(PhotoSize.MEDIUM);
        }

        public URL getLargeUrl() throws QuickrException {
            return this.getUrl(PhotoSize.LARGE);
        }

        public URL getOriginalUrl(String ext) throws QuickrException {
            PhotoUrl purl = new PhotoUrl(this.getStaticUrl(), this.getServer(), this.getPhotoId(), this.getPhotoSecret(), ext);
            return purl.getUrl();
        }

        public String toString() {
            return this.getClass().getName() + " { photoId=" + this.getPhotoId() + ", server=" + this.getServer() + ", owner=" + this.getOwner() + ", secret=" + this.getPhotoSecret() + ", title=" + this.getTitle() + " }";
        }

        public String getPhotoId() {
            return this.photoId;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getPhotoSecret() {
            return this.photoSecret;
        }

        public String getServer() {
            return this.server;
        }

        public String getShortTitle() {
            return this.shortTitle;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPublicAccessible() {
            return this.publicAccessible;
        }

        public boolean isFriendAccessible() {
            return this.friendAccessible;
        }

        public boolean isFamilyAccessible() {
            return this.familyAccessible;
        }

        public String getStaticUrl() {
            return this.staticUrl;
        }
    }
}

