/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.Map;
import org.jtb.quickr.AuthResponse;
import org.jtb.quickr.Get;
import org.jtb.quickr.PhotosResponse;
import org.jtb.quickr.PhotosSearchCriteria;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.SignedMethodRequest;
import org.jtb.quickr.SignedMethodUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PhotosSearchRequest
extends SignedMethodRequest {
    private String staticUrl;
    private PhotosSearchCriteria photosSearchCriteria;

    protected PhotosSearchRequest(String baseUrl, String apiKey, String secret, AuthResponse.Token authToken, PhotosSearchCriteria photosSearchCriteria, String staticUrl) throws QuickrException {
        super(baseUrl, apiKey, secret, authToken, "flickr.photos.search");
        this.photosSearchCriteria = photosSearchCriteria;
        this.staticUrl = staticUrl;
    }

    @Override
    protected Map<String, String> getArgs() {
        PhotosSearchCriteria psc = this.photosSearchCriteria;
        if (psc.getUserId() != null) {
            this.putArg("user_id", psc.getUserId());
        }
        if (psc.getTags() != null && psc.getTags().size() > 0) {
            this.putArg("tags", PhotosSearchRequest.join(psc.getTags(), ','));
        }
        if (psc.getTagMode() != null) {
            this.putArg("tag_mode", psc.getTagMode().toString());
        }
        if (psc.getText() != null) {
            this.putArg("text", psc.getText());
        }
        if (psc.getMinUploadDate() != null) {
            this.putArg("min_upload_date", Long.toString(psc.getMinUploadDate().getTime()));
        }
        if (psc.getMaxUploadDate() != null) {
            this.putArg("max_upload_date", Long.toString(psc.getMaxUploadDate().getTime()));
        }
        if (psc.getMinTakenDate() != null) {
            this.putArg("min_taken_date", Long.toString(psc.getMinTakenDate().getTime()));
        }
        if (psc.getMaxTakenDate() != null) {
            this.putArg("max_taken_date", Long.toString(psc.getMaxTakenDate().getTime()));
        }
        if (psc.getLicenses() != null && psc.getLicenses().size() > 0) {
            this.putArg("license", PhotosSearchRequest.join(psc.getLicenses(), ','));
        }
        if (psc.getSort() != null) {
            this.putArg("sort", psc.getSort().toString());
        }
        if (psc.getPrivacyFilter() != null) {
            this.putArg("privacy_filter", psc.getPrivacyFilter().toString());
        }
        if (psc.getBoundingBox() != null) {
            this.putArg("bbox", psc.getBoundingBox().toString());
        }
        if (psc.getLocationAccuracy() != null) {
            this.putArg("accuracy", psc.getLocationAccuracy().toString());
        }
        if (psc.getExtras() != null && psc.getExtras().size() > 0) {
            this.putArg("extras", PhotosSearchRequest.join(psc.getExtras(), ','));
        }
        if (psc.getPerPage() != null) {
            this.putArg("per_page", psc.getPerPage().toString());
        }
        if (psc.getPage() != null) {
            this.putArg("page", psc.getPage().toString());
        }
        return super.getArgs();
    }

    @Override
    public PhotosResponse execute() throws QuickrException {
        SignedMethodUrl furl = new SignedMethodUrl(this.getBaseUrl(), this.getArgs(), this.getApiKey(), this.getSecret(), this.getAuthToken(), this.getMethod());
        Get get = new Get(furl.getUrl());
        InputStream is = get.execute();
        PhotosResponse pres = new PhotosResponse(is, this.staticUrl);
        return pres;
    }
}

