/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jtb.quickr.AuthResponse;
import org.jtb.quickr.ContextsResponse;
import org.jtb.quickr.PhotoIdResponse;
import org.jtb.quickr.PhotoResponse;
import org.jtb.quickr.PhotosAddTagsRequest;
import org.jtb.quickr.PhotosDeleteRequest;
import org.jtb.quickr.PhotosGetAllContextsRequest;
import org.jtb.quickr.PhotosGetInfoRequest;
import org.jtb.quickr.PhotosResponse;
import org.jtb.quickr.PhotosSearchCriteria;
import org.jtb.quickr.PhotosSearchRequest;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotosService
extends Service {
    private static Logger logger = Logger.getLogger((String)PhotosService.class.getName());

    public PhotosService() throws QuickrException {
    }

    public PhotosService(Properties properties) throws QuickrException {
        super(properties);
    }

    public void delete(AuthResponse.Token authToken, PhotoIdResponse photoId) throws QuickrException {
        PhotosDeleteRequest pdr = new PhotosDeleteRequest(this.properties.getRestUrl(), this.properties.getApiKey(), this.properties.getSecret(), authToken, photoId);
        pdr.execute();
    }

    public PhotosResponse search(PhotosSearchCriteria criteria) throws QuickrException {
        PhotosSearchRequest psr = new PhotosSearchRequest(this.properties.getRestUrl(), this.properties.getApiKey(), null, null, criteria, this.properties.getStaticUrl());
        PhotosResponse photos = psr.execute();
        return photos;
    }

    public PhotosResponse search(AuthResponse.Token authToken, PhotosSearchCriteria criteria) throws QuickrException {
        PhotosSearchRequest psr = new PhotosSearchRequest(this.properties.getRestUrl(), this.properties.getApiKey(), this.properties.getSecret(), authToken, criteria, this.properties.getStaticUrl());
        PhotosResponse photos = psr.execute();
        return photos;
    }

    public PhotoResponse getInfo(String photoId, String photoSecret) throws QuickrException {
        PhotosGetInfoRequest pgir = new PhotosGetInfoRequest(this.properties.getRestUrl(), this.properties.getApiKey(), photoId, photoSecret, this.properties.getStaticUrl());
        PhotoResponse photo = pgir.execute();
        return photo;
    }

    public PhotoResponse getInfo(String photoId) throws QuickrException {
        PhotosGetInfoRequest pgir = new PhotosGetInfoRequest(this.properties.getRestUrl(), this.properties.getApiKey(), photoId, null, this.properties.getStaticUrl());
        PhotoResponse photo = pgir.execute();
        return photo;
    }

    public void addTags(AuthResponse.Token authToken, String photoId, Set<String> tags) throws QuickrException {
        PhotosAddTagsRequest patr = new PhotosAddTagsRequest(this.properties.getRestUrl(), this.properties.getApiKey(), this.properties.getSecret(), authToken, photoId, tags);
        patr.execute();
    }

    public ContextsResponse getAllContexts(String photoId) throws QuickrException {
        PhotosGetAllContextsRequest pgacr = new PhotosGetAllContextsRequest(this.properties.getRestUrl(), this.properties.getApiKey(), photoId);
        ContextsResponse cr = pgacr.execute();
        return cr;
    }
}

