/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jtb.quickr.FlickrResponse;
import org.jtb.quickr.QuickrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextsResponse
extends FlickrResponse {
    private static Logger logger = Logger.getLogger((String)ContextsResponse.class.getName());
    private Set<PhotoSet> sets;
    private Set<PhotoPool> pools;

    ContextsResponse(InputStream is) throws QuickrException {
        this.init(is);
    }

    @Override
    protected void populate(Element e) throws QuickrException {
        this.sets = new HashSet<PhotoSet>();
        List setElements = e.getChildren("set");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("number of sets: " + setElements.size()));
        }
        for (Element setElement : setElements) {
            PhotoSet ps = new PhotoSet(setElement);
            this.sets.add(ps);
        }
        this.pools = new HashSet<PhotoPool>();
        List poolElements = e.getChildren("pool");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("number of pools: " + poolElements.size()));
        }
        for (Element poolElement : poolElements) {
            PhotoPool pp = new PhotoPool(poolElement);
            this.pools.add(pp);
        }
    }

    public Set<PhotoSet> getSets() {
        return Collections.unmodifiableSet(this.sets);
    }

    public Set<PhotoPool> getPools() {
        return Collections.unmodifiableSet(this.pools);
    }

    public static class PhotoPool
    extends FlickrResponse {
        private String id;
        private String title;

        PhotoPool(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            this.id = e.getAttributeValue("id");
            this.title = e.getAttributeValue("title");
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class PhotoSet
    extends FlickrResponse {
        private String id;
        private String title;

        PhotoSet(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            this.id = e.getAttributeValue("id");
            this.title = e.getAttributeValue("title");
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

