/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jtb.quickr.FlickrResponse;
import org.jtb.quickr.QuickrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsResponse
extends FlickrResponse {
    private static Logger logger = Logger.getLogger((String)GroupsResponse.class.getName());
    private List<Group> groups;

    GroupsResponse(InputStream is) throws QuickrException {
        this.init(is);
    }

    @Override
    protected void populate(Element e) throws QuickrException {
        Element groupsElement = e.getChild("groups");
        this.groups = new ArrayList<Group>();
        List groupElements = groupsElement.getChildren("group");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("number of groups: " + groupElements.size()));
        }
        for (Element groupElement : groupElements) {
            Group g = new Group(groupElement);
            this.groups.add(g);
        }
    }

    public List<Group> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public static class Group
    extends FlickrResponse {
        private String nsId;
        private String name;
        private boolean admin;
        private boolean eighteenPlus;

        Group(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            this.admin = Group.getAttrBoolean(e, "admin");
            this.eighteenPlus = Group.getAttrBoolean(e, "eighteenplus");
            this.nsId = e.getAttributeValue("nsid");
            this.name = e.getAttributeValue("name");
        }

        public String getNsId() {
            return this.nsId;
        }

        public String getName() {
            return this.name;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public boolean isEighteenPlus() {
            return this.eighteenPlus;
        }
    }
}

