/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jtb.quickr.AuthResponse;
import org.jtb.quickr.EmptyReponse;
import org.jtb.quickr.FlickrUrl;
import org.jtb.quickr.HttpVerb;
import org.jtb.quickr.Post;
import org.jtb.quickr.PostUrl;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.SignedMethodRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PhotosAddTagsRequest
extends SignedMethodRequest {
    private static Logger logger = Logger.getLogger((String)PhotosAddTagsRequest.class.getName());
    private String photoId;
    private Set<String> tags;

    protected PhotosAddTagsRequest(String baseUrl, String apiKey, String secret, AuthResponse.Token authToken, String photoId, Set<String> tags) {
        super(baseUrl, apiKey, secret, authToken, "flickr.photos.addTags");
        this.photoId = photoId;
        this.tags = tags;
    }

    @Override
    protected Map<String, String> getArgs() {
        this.putArg("photo_id", this.photoId);
        this.putArg("tags", PhotosAddTagsRequest.join(this.tags, ' '));
        return super.getArgs();
    }

    @Override
    public EmptyReponse execute() throws QuickrException {
        PostUrl furl = new PostUrl(this.getBaseUrl(), this.getArgs(), this.getApiKey(), this.getSecret(), this.getAuthToken());
        Map<String, String> args = ((FlickrUrl)furl).getArgs();
        HashMap<String, Object> params = new HashMap<String, Object>(args);
        Post post = new Post(furl.getUrl(), params);
        InputStream is = ((HttpVerb)post).execute();
        EmptyReponse nr = new EmptyReponse(is);
        return nr;
    }
}

