/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.jtb.quickr.HttpVerb;
import org.jtb.quickr.QuickrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Post
extends HttpVerb {
    static Logger logger = Logger.getLogger((String)Post.class.getName());
    private Map<String, Object> params;

    public Post(URL url, Map<String, Object> params) {
        super(url);
        this.params = params;
    }

    protected Map<String, Object> getParameters() {
        return this.params;
    }

    @Override
    public InputStream execute() throws QuickrException {
        PostMethod postMethod = new PostMethod(this.getUrl().toString());
        this.addPostParameters(postMethod);
        InputStream is = null;
        HttpClient httpClient = this.getHttpClient();
        try {
            int status = httpClient.executeMethod((HttpMethod)postMethod);
            if (status != 200) {
                throw new QuickrException("post failed, status: " + status);
            }
            if (logger.isDebugEnabled()) {
                String response = postMethod.getResponseBodyAsString();
                logger.debug((Object)("post response:\n" + response));
            }
            is = postMethod.getResponseBodyAsStream();
        }
        catch (IOException ioe) {
            throw new QuickrException("could not post to URL: " + this.getUrl());
        }
        return is;
    }

    protected void addPostParameters(PostMethod method) throws QuickrException {
        for (String key : this.params.keySet()) {
            String val = (String)this.params.get(key);
            method.addParameter(key, val);
        }
    }
}

