/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jtb.quickr.QuickrException;

class QuickrProperties {
    private static Logger logger = Logger.getLogger((String)QuickrProperties.class.getName());
    private static QuickrProperties quickrProperties = null;
    private Properties properties;

    private QuickrProperties() throws QuickrException {
        InputStream is = this.getClass().getResourceAsStream("/quickr.properties");
        if (is == null) {
            throw new QuickrException("could not find quickr.properties in class path");
        }
        this.properties = new Properties();
        try {
            this.properties.load(is);
        }
        catch (IOException ioe) {
            throw new QuickrException("could not load quickr.properties", ioe);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("quickr.properties:\n" + this.properties));
        }
    }

    public static synchronized QuickrProperties getDefaultInstance() throws QuickrException {
        if (quickrProperties == null) {
            quickrProperties = new QuickrProperties();
        }
        return quickrProperties;
    }

    public QuickrProperties(Properties properties) {
        this.properties = properties;
    }

    public String getRestUrl() {
        return this.properties.getProperty("restUrl");
    }

    public String getApiKey() {
        return this.properties.getProperty("apiKey");
    }

    public String getSecret() {
        return this.properties.getProperty("secret");
    }

    public String getAuthUrl() {
        return this.properties.getProperty("authUrl");
    }

    public String getStaticUrl() {
        return this.properties.getProperty("staticUrl");
    }

    public String getUploadUrl() {
        return this.properties.getProperty("uploadUrl");
    }
}

