/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jtb.quickr.ApiSignature;
import org.jtb.quickr.AuthResponse;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.ServiceUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SignedUrl
extends ServiceUrl {
    private static Logger logger = Logger.getLogger((String)SignedUrl.class.getName());
    private String secret;
    private AuthResponse.Token authToken;

    public SignedUrl(String baseUrl, String apiKey, String secret) throws QuickrException {
        this(baseUrl, new HashMap<String, String>(), apiKey, secret, null);
    }

    public SignedUrl(String baseUrl, String apiKey, String secret, AuthResponse.Token authToken) throws QuickrException {
        this(baseUrl, new HashMap<String, String>(), apiKey, secret, authToken);
    }

    public SignedUrl(String baseUrl, Map<String, String> args, String apiKey, String secret) throws QuickrException {
        this(baseUrl, args, apiKey, secret, null);
    }

    public SignedUrl(String baseUrl, Map<String, String> args, String apiKey, String secret, AuthResponse.Token authToken) throws QuickrException {
        super(baseUrl, args, apiKey);
        this.secret = secret;
        this.authToken = authToken;
    }

    @Override
    protected Map<String, String> getArgs() {
        if (this.authToken != null) {
            this.putArg("auth_token", this.authToken.toString());
        }
        if (this.secret != null) {
            ApiSignature apiSig = new ApiSignature(this.secret, super.getArgs());
            String sig = apiSig.getSignature();
            this.putArg("api_sig", sig);
        }
        return super.getArgs();
    }
}

