/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jtb.quickr.AuthResponse;
import org.jtb.quickr.BooleanInt;
import org.jtb.quickr.FlickrUrl;
import org.jtb.quickr.HttpVerb;
import org.jtb.quickr.MultipartPost;
import org.jtb.quickr.PhotoIdResponse;
import org.jtb.quickr.PostUrl;
import org.jtb.quickr.QuickrException;
import org.jtb.quickr.SignedRequest;
import org.jtb.quickr.UploadCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UploadRequest
extends SignedRequest {
    private static Logger logger = Logger.getLogger((String)UploadRequest.class.getName());
    private UploadCriteria photoUpload;

    protected UploadRequest(String baseUrl, String apiKey, String secret, AuthResponse.Token authToken, UploadCriteria photoUpload) {
        super(baseUrl, apiKey, secret, authToken);
        this.photoUpload = photoUpload;
    }

    @Override
    protected Map<String, String> getArgs() {
        Boolean familyPhoto;
        Boolean friendPhoto;
        Boolean publicPhoto;
        Set<String> tags;
        String description;
        String title = this.photoUpload.getTitle();
        if (this.photoUpload.getTitle() != null) {
            this.putArg("title", title);
        }
        if ((description = this.photoUpload.getDescription()) != null) {
            this.putArg("description", description);
        }
        if ((tags = this.photoUpload.getTags()) != null && tags.size() > 0) {
            this.putArg("tags", UploadRequest.join(tags, ' '));
        }
        if ((publicPhoto = this.photoUpload.getPublicPhoto()) != null) {
            this.putArg("is_public", new BooleanInt(publicPhoto).toString());
        }
        if ((friendPhoto = this.photoUpload.getFriendPhoto()) != null) {
            this.putArg("is_friend", new BooleanInt(friendPhoto).toString());
        }
        if ((familyPhoto = this.photoUpload.getFamilyPhoto()) != null) {
            this.putArg("is_family", new BooleanInt(familyPhoto).toString());
        }
        return super.getArgs();
    }

    @Override
    public PhotoIdResponse execute() throws QuickrException {
        PostUrl furl = new PostUrl(this.getBaseUrl(), this.getArgs(), this.getApiKey(), this.getSecret(), this.getAuthToken());
        Map<String, String> args = ((FlickrUrl)furl).getArgs();
        HashMap<String, Object> data = new HashMap<String, Object>(args);
        data.put("photo", (String)((Object)this.photoUpload.getPhoto()));
        MultipartPost post = new MultipartPost(furl.getUrl(), data);
        InputStream is = ((HttpVerb)post).execute();
        PhotoIdResponse pid = new PhotoIdResponse(is);
        return pid;
    }
}

