/*
 * Decompiled with CFR 0.152.
 */
package org.jtb.quickr;

import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jtb.quickr.FlickrResponse;
import org.jtb.quickr.QuickrException;

public class UserResponse
extends FlickrResponse {
    private static Logger logger = Logger.getLogger((String)UserResponse.class.getName());
    private String nsId;
    private String userName;
    private boolean pro;
    private Bandwidth bandwidth;
    private Sets sets;
    private Filesize filesize;

    UserResponse(InputStream is) throws QuickrException {
        super(is);
    }

    protected void populate(Element e) throws QuickrException {
        Element setsElement;
        Element filesizeElement;
        Element userElement = e.getChild("user");
        this.nsId = userElement.getAttributeValue("nsid");
        this.userName = UserResponse.getBodyString(userElement, "username");
        this.pro = UserResponse.getAttrBoolean(e, "ispro");
        Element bandwidthElement = e.getChild("bandwidth");
        if (bandwidthElement != null) {
            this.bandwidth = new Bandwidth(bandwidthElement);
        }
        if ((filesizeElement = e.getChild("filesize")) != null) {
            this.filesize = new Filesize(filesizeElement);
        }
        if ((setsElement = e.getChild("sets")) != null) {
            this.sets = new Sets(setsElement);
        }
    }

    public String getNsId() {
        return this.nsId;
    }

    private void setNsId(String nsId) {
        this.nsId = nsId;
    }

    public String getUserName() {
        return this.userName;
    }

    private void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isPro() {
        return this.pro;
    }

    public static class Sets
    extends FlickrResponse {
        private int created;
        private int remaining;

        Sets(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            Element setsElement = e.getChild("sets");
            this.created = Sets.getAttrInt(setsElement, "created");
            try {
                this.remaining = Sets.getAttrInt(setsElement, "remaining");
            }
            catch (NumberFormatException nfe) {
                this.remaining = Integer.MAX_VALUE;
            }
        }

        public int getCreated() {
            return this.created;
        }

        public int getRemaining() {
            return this.remaining;
        }
    }

    public static class Filesize
    extends FlickrResponse {
        private long maxBytes;
        private int maxKBytes;

        Filesize(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            Element filesizeElement = e.getChild("filesize");
            this.maxBytes = Filesize.getAttrLong(filesizeElement, "maxbytes");
            this.maxKBytes = Filesize.getAttrInt(filesizeElement, "maxkbytes");
        }

        public long getMaxBytes() {
            return this.maxBytes;
        }

        public int getMaxKBytes() {
            return this.maxKBytes;
        }
    }

    public static class Bandwidth
    extends FlickrResponse {
        private long maxBytes;
        private int maxKBytes;
        private long usedBytes;
        private int usedKBytes;
        private long remainingBytes;
        private int remainingKBytes;

        Bandwidth(Element e) throws QuickrException {
            super(e);
        }

        protected void populate(Element e) {
            Element bwElement = e.getChild("bandwidth");
            this.maxBytes = Bandwidth.getAttrLong(bwElement, "maxbytes");
            this.maxKBytes = Bandwidth.getAttrInt(bwElement, "maxkbytes");
            this.usedBytes = Bandwidth.getAttrLong(bwElement, "usedbytes");
            this.usedKBytes = Bandwidth.getAttrInt(bwElement, "usedkbytes");
            this.remainingBytes = Bandwidth.getAttrLong(bwElement, "remainingbytes");
            this.remainingKBytes = Bandwidth.getAttrInt(bwElement, "remainingkbytes");
        }

        public long getMaxBytes() {
            return this.maxBytes;
        }

        public int getMaxKBytes() {
            return this.maxKBytes;
        }

        public long getUsedBytes() {
            return this.usedBytes;
        }

        public int getUsedKBytes() {
            return this.usedKBytes;
        }

        public long getRemainingBytes() {
            return this.remainingBytes;
        }

        public int getRemainingKBytes() {
            return this.remainingKBytes;
        }
    }
}

