/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.Date;
import org.fest.assertions.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoImpl;
import org.jtransfo.ObjectFinder;
import org.jtransfo.StringEnumTypeConverter;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.jtransfo.object.Gender;
import org.jtransfo.object.PersonDomain;
import org.jtransfo.object.PersonTo;
import org.junit.Before;
import org.junit.Test;

public class FinderAndConverterTest {
    private static final String NAME = "ikke";
    private JTransfo jTransfo;

    @Before
    public void setup() throws Exception {
        JTransfoImpl impl = new JTransfoImpl();
        this.jTransfo = impl;
        AddressDomain[] addresses = new AddressDomain[10];
        for (int i = 0; i < 10; ++i) {
            AddressDomain ad = new AddressDomain();
            ad.setId(Long.valueOf(i));
            ad.setAddress("Address " + i);
            addresses[i] = ad;
        }
        impl.getTypeConverters().add(new StringEnumTypeConverter(Gender.class));
        impl.updateTypeConverters();
        impl.getObjectFinders().add(new AddressFinder(addresses));
        impl.updateObjectFinders();
    }

    @Test
    public void testWithFinderAndConverterToDomain() throws Exception {
        PersonTo to = new PersonTo();
        to.setGender("MALE");
        to.setLastChanged(new Date());
        to.setName(NAME);
        to.setAddress(new AddressTo(3L));
        PersonDomain domain = (PersonDomain)this.jTransfo.convert((Object)to);
        Assertions.assertThat((String)domain.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(3L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNotNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Address 3");
        Assertions.assertThat((Object)domain.getLastChanged()).isNull();
    }

    @Test
    public void testWithFinderAndConverterToTo() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName(NAME);
        Date now = new Date();
        domain.setLastChanged(now);
        AddressDomain address = new AddressDomain();
        address.setId(7L);
        address.setAddress("Kerkstraat");
        domain.setAddress(address);
        PersonTo to = (PersonTo)this.jTransfo.convert((Object)domain, (Object)new PersonTo(), new String[0]);
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Object)to.getAddress()).isNotNull();
        Assertions.assertThat((Long)to.getAddress().getId()).isEqualTo(7L);
        Assertions.assertThat((Object)to.getLastChanged()).isEqualTo((Object)now);
    }

    private class AddressFinder
    implements ObjectFinder {
        private AddressDomain[] addresses;

        public AddressFinder(AddressDomain[] addresses) {
            this.addresses = addresses;
        }

        public <T> T getObject(Class<T> domainClass, Object to) {
            if (domainClass.isAssignableFrom(AddressDomain.class) && to instanceof AddressTo) {
                return (T)this.addresses[((AddressTo)to).getId().intValue()];
            }
            return null;
        }
    }
}

