/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.ArrayList;
import java.util.List;
import org.fest.assertions.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.ListTypeConverter;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.AddressTo;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ListTypeConverterTest {
    private static final String NAME = "cname";
    ListTypeConverter listTypeConverter;
    @Mock
    private JTransfo jTransfo;
    @Mock
    private SyntheticField field;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.listTypeConverter = new ListTypeConverter(NAME, AddressTo.class);
        Mockito.when((Object)this.jTransfo.getDomainClass(AddressTo.class)).thenReturn(AddressDomain.class);
        Mockito.when((Object)this.jTransfo.getToSubType((Class)Matchers.eq(AddressTo.class), Matchers.anyObject())).thenReturn(AddressTo.class);
        this.listTypeConverter.setJTransfo(this.jTransfo);
    }

    @Test
    public void testGetName() throws Exception {
        Assertions.assertThat((String)this.listTypeConverter.getName()).isEqualTo((Object)NAME);
    }

    @Test
    public void testCanConvert() throws Exception {
        Assertions.assertThat((boolean)this.listTypeConverter.canConvert(List.class, List.class)).isFalse();
    }

    @Test
    public void testConvert() throws Exception {
        AddressTo to1 = new AddressTo();
        to1.setId(1L);
        AddressTo to2 = new AddressTo();
        to2.setId(2L);
        ArrayList<AddressTo> addresses = new ArrayList<AddressTo>();
        addresses.add(to1);
        addresses.add(to2);
        String[] tags = new String[]{"a", "b", "c"};
        List res = this.listTypeConverter.convert(addresses, this.field, null, tags);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)to1, AddressDomain.class, tags);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)to2, AddressDomain.class, tags);
    }

    @Test
    public void testConvertNull() throws Exception {
        Assertions.assertThat((List)this.listTypeConverter.convert(null, this.field, null, new String[0])).isEmpty();
        this.listTypeConverter.setKeepNullList(true);
        Assertions.assertThat((List)this.listTypeConverter.convert(null, this.field, null, new String[0])).isNull();
        ArrayList<Object> listWithNull = new ArrayList<Object>();
        listWithNull.add(null);
        Assertions.assertThat((List)this.listTypeConverter.convert(listWithNull, this.field, null, new String[0])).isEqualTo(listWithNull);
    }

    @Test
    public void testReverse() throws Exception {
        AddressDomain ad1 = new AddressDomain();
        ad1.setId(1L);
        AddressDomain ad2 = new AddressDomain();
        ad2.setId(2L);
        ArrayList<AddressDomain> addresses = new ArrayList<AddressDomain>();
        addresses.add(ad1);
        addresses.add(ad2);
        List res = this.listTypeConverter.reverse(addresses, this.field, null, new String[0]);
        Assertions.assertThat((List)res).isNotNull();
        Assertions.assertThat((List)res).hasSize(2);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad1, AddressTo.class, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convertTo((Object)ad2, AddressTo.class, new String[0]);
    }

    @Test
    public void testReverseNull() throws Exception {
        Assertions.assertThat((List)this.listTypeConverter.reverse(null, this.field, null, new String[0])).isEmpty();
        this.listTypeConverter.setKeepNullList(true);
        Assertions.assertThat((List)this.listTypeConverter.reverse(null, this.field, null, new String[0])).isNull();
    }
}

