/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.fest.assertions.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.ReadOnlyDomainTypeConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.SimpleBaseDomain;
import org.jtransfo.object.SimpleBaseTo;
import org.jtransfo.object.SimpleExtendedDomain;
import org.jtransfo.object.SimpleExtendedTo;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ReadOnlyDomainTypeConverterTest {
    private TypeConverter typeConverter;
    @Mock
    private JTransfo jTransfo;
    @Mock
    private ReflectionHelper reflectionHelper;
    @Mock
    private SyntheticField toField;
    @Mock
    private SyntheticField domainField;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.typeConverter = new ReadOnlyDomainTypeConverter();
        ((ReadOnlyDomainTypeConverter)this.typeConverter).setJTransfo(this.jTransfo);
        ReflectionTestUtils.setField((Object)this.typeConverter, (String)"reflectionHelper", (Object)this.reflectionHelper);
        Mockito.when((Object)this.jTransfo.isToClass(SimpleBaseTo.class)).thenReturn((Object)true);
        Mockito.when((Object)this.jTransfo.isToClass(SimpleExtendedTo.class)).thenReturn((Object)true);
        Mockito.when((Object)this.jTransfo.getDomainClass(SimpleBaseTo.class)).thenReturn(SimpleBaseDomain.class);
        Mockito.when((Object)this.jTransfo.getDomainClass(SimpleExtendedTo.class)).thenReturn(SimpleExtendedDomain.class);
        Mockito.when((Object)this.jTransfo.getToSubType((Class)Matchers.eq(SimpleBaseTo.class), Matchers.anyObject())).thenReturn(SimpleBaseTo.class);
        Mockito.when((Object)this.domainField.getType()).thenReturn(SimpleBaseDomain.class);
        Mockito.when((Object)this.toField.getType()).thenReturn(SimpleBaseTo.class);
    }

    @Test
    public void testCanConvert() throws Exception {
        Assertions.assertThat((boolean)this.typeConverter.canConvert(String.class, String.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleBaseTo.class, SimpleBaseDomain.class)).isTrue();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleBaseTo.class, String.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleBaseTo.class, SimpleExtendedDomain.class)).isFalse();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleExtendedTo.class, SimpleExtendedDomain.class)).isTrue();
        Assertions.assertThat((boolean)this.typeConverter.canConvert(SimpleExtendedTo.class, SimpleBaseDomain.class)).isTrue();
    }

    @Test
    public void testConvert() throws Exception {
        SimpleBaseTo source = new SimpleBaseTo();
        this.typeConverter.convert((Object)source, this.domainField, null, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).findTarget((Object)source, SimpleBaseDomain.class);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).getDomainClass(SimpleBaseTo.class);
        Assertions.assertThat((Object)this.typeConverter.convert((Object)source, this.domainField, null, new String[0])).isNull();
    }

    @Test
    public void testConvertNull() throws Exception {
        Assertions.assertThat((Object)this.typeConverter.convert(null, this.domainField, null, new String[0])).isNull();
    }

    @Test
    public void testReverse() throws Exception {
        SimpleBaseDomain source = new SimpleBaseDomain();
        SimpleBaseTo target = new SimpleBaseTo();
        Mockito.when((Object)this.reflectionHelper.newInstance((Class)Matchers.any(Class.class))).thenReturn((Object)target);
        this.typeConverter.reverse((Object)source, this.toField, null, new String[0]);
        ((JTransfo)Mockito.verify((Object)this.jTransfo)).convert((Object)source, (Object)target, new String[0]);
    }

    @Test
    public void testReverseNullHandling() throws Exception {
        Assertions.assertThat((Object)this.typeConverter.reverse(null, this.toField, null, new String[0])).isNull();
    }

    @Test
    public void testReverseInstantiationException() throws Exception {
        SimpleBaseDomain source = new SimpleBaseDomain();
        Mockito.when((Object)this.reflectionHelper.newInstance((Class)Matchers.any(Class.class))).thenThrow(new Throwable[]{new InstantiationException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance of transfer object class org.jtransfo.object.SimpleBaseTo.");
        this.typeConverter.reverse((Object)source, this.toField, null, new String[0]);
    }

    @Test
    public void testReverseIllegalAccessException() throws Exception {
        SimpleBaseDomain source = new SimpleBaseDomain();
        Mockito.when((Object)this.reflectionHelper.newInstance((Class)Matchers.any(Class.class))).thenThrow(new Throwable[]{new IllegalAccessException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot create instance of transfer object class org.jtransfo.object.SimpleBaseTo.");
        this.typeConverter.reverse((Object)source, this.toField, null, new String[0]);
    }

    @Test
    public void testName() throws Exception {
        Assertions.assertThat((String)((ReadOnlyDomainTypeConverter)this.typeConverter).getName()).isEqualTo((Object)"readOnlyDomain");
        ((ReadOnlyDomainTypeConverter)this.typeConverter).setName("bla");
        Assertions.assertThat((String)((ReadOnlyDomainTypeConverter)this.typeConverter).getName()).isEqualTo((Object)"bla");
    }
}

