/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.fest.assertions.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoImpl;
import org.jtransfo.StringEnumTypeConverter;
import org.jtransfo.object.Gender;
import org.jtransfo.object.MalePersonTo;
import org.jtransfo.object.PersonDomain;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StaticFieldConversionTest {
    private JTransfo jTransfo;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        JTransfoImpl impl = new JTransfoImpl();
        this.jTransfo = impl;
        impl.getTypeConverters().add(new StringEnumTypeConverter(Gender.class));
        impl.updateTypeConverters();
    }

    @Test
    public void testToDomain() throws Exception {
        MalePersonTo person = new MalePersonTo();
        person.setName("Joske Vermeulen");
        PersonDomain res = (PersonDomain)this.jTransfo.convert((Object)person);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"Joske Vermeulen");
        Assertions.assertThat((Object)((Object)res.getGender())).isEqualTo((Object)Gender.MALE);
    }

    @Test
    public void testToTo() throws Exception {
        PersonDomain person = new PersonDomain();
        person.setName("Joske Vermeulen");
        person.setGender(Gender.FEMALE);
        MalePersonTo res = (MalePersonTo)this.jTransfo.convertTo((Object)person, MalePersonTo.class, new String[0]);
        Assertions.assertThat((String)res.getName()).isEqualTo((Object)"Joske Vermeulen");
    }
}

