/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.fest.assertions.Assertions;
import org.jtransfo.StringEnumTypeConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.Gender;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class StringEnumTypeConverterTest {
    private TypeConverter<String, Gender> enumTypeConverter;
    @Mock
    private SyntheticField genderField;
    @Mock
    private SyntheticField stringField;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.enumTypeConverter = new StringEnumTypeConverter(Gender.class);
        Mockito.when((Object)this.genderField.getType()).thenReturn(Gender.class);
        Mockito.when((Object)this.stringField.getType()).thenReturn(String.class);
    }

    @Test
    public void testCanConvert() throws Exception {
        Assertions.assertThat((boolean)this.enumTypeConverter.canConvert(String.class, Gender.class)).isTrue();
        Assertions.assertThat((boolean)this.enumTypeConverter.canConvert(Object.class, Gender.class)).isFalse();
        Assertions.assertThat((boolean)this.enumTypeConverter.canConvert(String.class, String.class)).isFalse();
        Assertions.assertThat((boolean)this.enumTypeConverter.canConvert(Gender.class, String.class)).isFalse();
    }

    @Test
    public void testConvert() throws Exception {
        Assertions.assertThat((Object)this.enumTypeConverter.convert((Object)Gender.MALE.name(), this.genderField, null, new String[0])).isEqualTo((Object)Gender.MALE);
        Assertions.assertThat((Object)this.enumTypeConverter.convert((Object)Gender.FEMALE.name(), this.genderField, null, new String[0])).isEqualTo((Object)Gender.FEMALE);
        Assertions.assertThat((Object)this.enumTypeConverter.convert(null, this.genderField, null, new String[0])).isNull();
        Assertions.assertThat((Object)this.enumTypeConverter.convert((Object)"", this.genderField, null, new String[0])).isNull();
        this.exception.expect(IllegalArgumentException.class);
        Assertions.assertThat((Object)this.enumTypeConverter.convert((Object)"blabla", this.genderField, null, new String[0]));
    }

    @Test
    public void testReverse() throws Exception {
        Assertions.assertThat((String)((String)this.enumTypeConverter.reverse((Object)Gender.MALE, this.stringField, null, new String[0]))).isEqualTo((Object)Gender.MALE.name());
        Assertions.assertThat((String)((String)this.enumTypeConverter.reverse((Object)Gender.FEMALE, this.stringField, null, new String[0]))).isEqualTo((Object)Gender.FEMALE.name());
        Assertions.assertThat((String)((String)this.enumTypeConverter.reverse(null, this.stringField, null, new String[0]))).isNull();
    }
}

