/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import org.fest.assertions.Assertions;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.AbstractConverter;
import org.jtransfo.internal.SimpleSyntheticField;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.object.SimpleExtendedDomain;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AbstractConverterTest {
    private int doConvertResult = 0;
    private AbstractConverter abstractConverter;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.abstractConverter = new TestConverter();
    }

    @Test
    public void testConvertNothing() throws Exception {
        this.abstractConverter.convert(null, null, new String[0]);
    }

    @Test
    public void testConvertJTransfoException() throws Exception {
        this.doConvertResult = 1;
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("jte");
        this.abstractConverter.convert(null, null, new String[0]);
    }

    @Test
    public void testConvertIllegalAccessException() throws Exception {
        this.doConvertResult = 2;
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("NoAccess");
        this.abstractConverter.convert(null, null, new String[0]);
    }

    @Test
    public void testConvertIllegalArgumentException() throws Exception {
        this.doConvertResult = 3;
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("argument");
        this.abstractConverter.convert(null, null, new String[0]);
    }

    @Test
    public void testDomainFieldName() throws Exception {
        SimpleSyntheticField sb = new SimpleSyntheticField(SimpleExtendedDomain.class.getDeclaredField("b"));
        SimpleSyntheticField sc = new SimpleSyntheticField(SimpleExtendedDomain.class.getDeclaredField("c"));
        SimpleSyntheticField si = new SimpleSyntheticField(SimpleExtendedDomain.class.getDeclaredField("i"));
        Assertions.assertThat((String)this.abstractConverter.domainFieldName(new SyntheticField[]{si})).isEqualTo((Object)"i");
        Assertions.assertThat((String)this.abstractConverter.domainFieldName(new SyntheticField[]{sc, si})).isEqualTo((Object)"i (with path c)");
        Assertions.assertThat((String)this.abstractConverter.domainFieldName(new SyntheticField[]{sb, sc, si})).isEqualTo((Object)"i (with path b.c)");
        Assertions.assertThat((String)this.abstractConverter.domainFieldName(new SyntheticField[0])).isEqualTo((Object)"");
    }

    private final class TestConverter
    extends AbstractConverter {
        private TestConverter() {
        }

        public void doConvert(Object source, Object target, String ... tags) throws JTransfoException, IllegalAccessException, IllegalArgumentException {
            switch (AbstractConverterTest.this.doConvertResult) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new JTransfoException("jte");
                }
                case 2: {
                    throw new IllegalAccessException("access");
                }
                case 3: {
                    throw new IllegalArgumentException("argument");
                }
            }
        }

        public String accessExceptionMessage() {
            return "NoAccess";
        }

        public String argumentExceptionMessage() {
            return "CannotConvert";
        }
    }
}

