/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import org.fest.assertions.Assertions;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.AccessorSyntheticField;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.object.ReadOnlyGetterDomain;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AccessorSyntheticField2Test {
    @Mock
    private ReflectionHelper reflectionHelper;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.reflectionHelper.getMethod(ReadOnlyGetterDomain.class, null, "getId", new Class[0])).thenReturn((Object)ReadOnlyGetterDomain.class.getMethod("getId", new Class[0]));
        Mockito.when((Object)this.reflectionHelper.getMethod(ReadOnlyGetterDomain.class, null, "setId", new Class[]{String.class})).thenReturn((Object)ReadOnlyGetterDomain.class.getMethod("setId", String.class));
        Mockito.when((Object)this.reflectionHelper.getMethod(ReadOnlyGetterDomain.class, null, "getTwice", new Class[0])).thenReturn((Object)ReadOnlyGetterDomain.class.getMethod("getTwice", new Class[0]));
    }

    @Test
    public void testConstructNoField() throws Exception {
        AccessorSyntheticField accessorSyntheticField = new AccessorSyntheticField(this.reflectionHelper, ReadOnlyGetterDomain.class, "id", false);
        Assertions.assertThat((String)accessorSyntheticField.getName()).isEqualTo((Object)"id");
        Assertions.assertThat((Object)accessorSyntheticField.getType()).isEqualTo(String.class);
        ReadOnlyGetterDomain domain = new ReadOnlyGetterDomain();
        accessorSyntheticField.set((Object)domain, (Object)"zzz");
        Assertions.assertThat((Object)accessorSyntheticField.get((Object)domain)).isEqualTo((Object)"zzz");
    }

    @Test
    public void testConstructNoAccessors() throws Exception {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot find getter from [getAhum, isAhum, hasAhum] on class org.jtransfo.object.ReadOnlyGetterDomain.");
        new AccessorSyntheticField(this.reflectionHelper, ReadOnlyGetterDomain.class, "ahum", false);
    }

    @Test
    public void testConstructNoSetter() throws Exception {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot find setter setTwice on class org.jtransfo.object.ReadOnlyGetterDomain.");
        new AccessorSyntheticField(this.reflectionHelper, ReadOnlyGetterDomain.class, "twice", false);
    }

    @Test
    public void testConstructNoFieldReadOnly() throws Exception {
        AccessorSyntheticField accessorSyntheticField = new AccessorSyntheticField(this.reflectionHelper, ReadOnlyGetterDomain.class, "twice", true);
        ReadOnlyGetterDomain domain = new ReadOnlyGetterDomain();
        domain.setId("ahum");
        Assertions.assertThat((Object)accessorSyntheticField.get((Object)domain)).isEqualTo((Object)"ahumahum");
    }
}

