/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.fest.assertions.Assertions;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.AccessorSyntheticField;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.object.SimpleBaseDomain;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

public class AccessorSyntheticFieldTest {
    private AccessorSyntheticField accessorSyntheticField;
    private SimpleBaseDomain domain;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.domain = (SimpleBaseDomain)Mockito.spy((Object)new SimpleBaseDomain());
        Field field = SimpleBaseDomain.class.getDeclaredField("a");
        ReflectionHelper reflectionHelper = new ReflectionHelper();
        reflectionHelper.makeAccessible(field);
        this.accessorSyntheticField = new AccessorSyntheticField(reflectionHelper, SimpleBaseDomain.class, field);
    }

    @Test
    public void testGet() throws Exception {
        this.accessorSyntheticField.get((Object)this.domain);
        ((SimpleBaseDomain)Mockito.verify((Object)this.domain)).getA();
    }

    @Test
    public void testGetNoGetter() throws Exception {
        ReflectionTestUtils.setField((Object)this.domain, (String)"a", (Object)"zzz");
        ReflectionTestUtils.setField((Object)this.accessorSyntheticField, (String)"getter", null);
        Assertions.assertThat((Object)this.accessorSyntheticField.get((Object)this.domain)).isEqualTo((Object)"zzz");
        ((SimpleBaseDomain)Mockito.verify((Object)this.domain, (VerificationMode)Mockito.times((int)0))).getA();
    }

    @Test
    public void testGetInvocationTargetException() throws Exception {
        Mockito.when((Object)this.domain.getA()).thenThrow(new Throwable[]{new JTransfoException("xxx")});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("InvocationTargetException trying to use getA on object of type org.jtransfo.object.SimpleBaseDomain");
        this.exception.expectMessage(". Expected type is org.jtransfo.object.SimpleBaseDomain. Cause is: xxx");
        this.accessorSyntheticField.get((Object)this.domain);
    }

    @Test
    public void testGetInvocationTargetException2() throws Exception {
        Mockito.when((Object)this.domain.getA()).thenThrow(new Throwable[]{new IOException("zzz")});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("InvocationTargetException trying to use getA on object of type org.jtransfo.object.SimpleBaseDomain");
        this.exception.expectMessage(". Expected type is org.jtransfo.object.SimpleBaseDomain. Cause is: zzz");
        this.accessorSyntheticField.get((Object)this.domain);
    }

    @Test
    public void testGetInvocationTargetException3() throws Exception {
        Mockito.when((Object)this.domain.getA()).thenThrow(new Throwable[]{new IllegalStateException("yyy")});
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("yyy");
        this.accessorSyntheticField.get((Object)this.domain);
    }

    @Test
    public void testSet() throws Exception {
        this.accessorSyntheticField.set((Object)this.domain, (Object)"bla");
        ((SimpleBaseDomain)Mockito.verify((Object)this.domain)).setA("bla");
    }

    @Test
    public void testSetNoSetter() throws Exception {
        ReflectionTestUtils.setField((Object)this.accessorSyntheticField, (String)"setter", null);
        this.accessorSyntheticField.set((Object)this.domain, (Object)"bla");
        ((SimpleBaseDomain)Mockito.verify((Object)this.domain, (VerificationMode)Mockito.times((int)0))).setA("bla");
        Assertions.assertThat((String)this.domain.getA()).isEqualTo((Object)"bla");
    }

    @Test
    public void testSetInvocationTargetException() throws Exception {
        ((SimpleBaseDomain)Mockito.doThrow((Throwable)new JTransfoException("xxx")).when((Object)this.domain)).setA("bla");
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("InvocationTargetException trying to use setA on object of type org.jtransfo.object.SimpleBaseDomain");
        this.exception.expectMessage(". Expected type is org.jtransfo.object.SimpleBaseDomain. Cause is: xxx");
        this.accessorSyntheticField.set((Object)this.domain, (Object)"bla");
    }

    @Test
    public void testSetInvocationTargetException2() throws Exception {
        ((SimpleBaseDomain)Mockito.doThrow((Throwable)new IOException("zzz")).when((Object)this.domain)).setA("bla");
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("InvocationTargetException trying to use setA on object of type org.jtransfo.object.SimpleBaseDomain");
        this.exception.expectMessage(". Expected type is org.jtransfo.object.SimpleBaseDomain. Cause is: zzz");
        this.accessorSyntheticField.set((Object)this.domain, (Object)"bla");
    }

    @Test
    public void testSetInvocationTargetException3() throws Exception {
        ((SimpleBaseDomain)Mockito.doThrow((Throwable)new IllegalStateException("yyy")).when((Object)this.domain)).setA("bla");
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("yyy");
        this.accessorSyntheticField.set((Object)this.domain, (Object)"bla");
    }

    @Test
    public void testGetName() throws Exception {
        Assertions.assertThat((String)this.accessorSyntheticField.getName()).isEqualTo((Object)"a");
    }

    @Test
    public void testGetType() throws Exception {
        Assertions.assertThat((Object)this.accessorSyntheticField.getType()).isEqualTo(String.class);
    }

    @Test
    public void testGetGetterNameAlternatives() throws Exception {
        Assertions.assertThat((List)this.accessorSyntheticField.getGetterNameAlternatives("bla")).containsExactly(new Object[]{"getBla", "isBla", "hasBla"});
        Assertions.assertThat((List)this.accessorSyntheticField.getGetterNameAlternatives("isBla")).containsExactly(new Object[]{"getIsBla", "isBla", "isIsBla"});
        Assertions.assertThat((List)this.accessorSyntheticField.getGetterNameAlternatives("hasBla")).containsExactly(new Object[]{"getHasBla", "isHasBla", "hasBla"});
    }
}

