/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.util.Collections;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.LockableList;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LockableListTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private LockableList<Integer> list;

    @Before
    public void setup() {
        this.list = new LockableList();
        this.list.add((Object)0);
        this.list.add((Object)1);
        this.list.add((Object)2);
    }

    @Test
    public void setTest() throws Exception {
        this.list.set(0, (Object)3);
        Assertions.assertThat((Integer)((Integer)this.list.get(0))).isEqualTo(3);
        Assertions.assertThat(this.list).hasSize(3);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Collection is read-only.");
        this.list.lock();
        this.list.set(0, (Object)0);
    }

    @Test
    public void addTest() throws Exception {
        this.list.add((Object)3);
        Assertions.assertThat(this.list).hasSize(4);
        Assertions.assertThat((Integer)((Integer)this.list.get(3))).isEqualTo(3);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Collection is read-only.");
        this.list.lock();
        this.list.add((Object)4);
    }

    @Test
    public void addPositionTest() throws Exception {
        this.list.add(0, (Object)3);
        Assertions.assertThat((Integer)((Integer)this.list.get(0))).isEqualTo(3);
        Assertions.assertThat(this.list).hasSize(4);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Collection is read-only.");
        this.list.lock();
        this.list.add(0, (Object)0);
    }

    @Test
    public void removeTest() throws Exception {
        this.list.remove(0);
        Assertions.assertThat(this.list).hasSize(2);
        Assertions.assertThat((Integer)((Integer)this.list.get(0))).isEqualTo(1);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Collection is read-only.");
        this.list.lock();
        this.list.remove(0);
    }

    @Test
    public void removeObjectTest() throws Exception {
        this.list.remove((Object)0);
        Assertions.assertThat(this.list).hasSize(2);
        Assertions.assertThat((Integer)((Integer)this.list.get(0))).isEqualTo(1);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Collection is read-only.");
        this.list.lock();
        this.list.remove((Object)1);
    }

    @Test
    public void clearTest() throws Exception {
        this.list.clear();
        ((ListAssert)Assertions.assertThat(this.list).hasSize(0)).isEmpty();
    }

    @Test
    public void clearLockedTest() throws Exception {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Collection is read-only.");
        this.list.lock();
        this.list.clear();
    }

    @Test
    public void addAllTest() throws Exception {
        this.list.addAll(Collections.singletonList(3));
        Assertions.assertThat(this.list).hasSize(4);
        Assertions.assertThat((Integer)((Integer)this.list.get(3))).isEqualTo(3);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Collection is read-only.");
        this.list.lock();
        this.list.addAll(Collections.singletonList(4));
    }

    @Test
    public void addAllPositionTest() throws Exception {
        this.list.addAll(0, Collections.singletonList(3));
        Assertions.assertThat(this.list).hasSize(4);
        Assertions.assertThat((Integer)((Integer)this.list.get(0))).isEqualTo(3);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Collection is read-only.");
        this.list.lock();
        this.list.addAll(0, Collections.singletonList(4));
    }

    @Test
    public void removeRangeTest() throws Exception {
        this.list.removeRange(0, 1);
        Assertions.assertThat(this.list).hasSize(2);
        Assertions.assertThat((Integer)((Integer)this.list.get(0))).isEqualTo(1);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Collection is read-only.");
        this.list.lock();
        this.list.removeRange(0, 1);
    }
}

