/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.lang.reflect.Field;
import org.fest.assertions.Assertions;
import org.jtransfo.JTransfoException;
import org.jtransfo.NoConversionTypeConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SimpleSyntheticField;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.internal.ToDomainConverter;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.PersonDomain;
import org.jtransfo.object.PersonTransitiveTo;
import org.jtransfo.object.SimpleBaseDomain;
import org.jtransfo.object.SimpleExtendedDomain;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ToDomainConverterTest {
    private static final String A_VALUE = "a value";
    private ToDomainConverter toDomainConverter;
    private ToDomainConverter toDomainConverterAccess;
    private ToDomainConverter toDomainConverterArgument;
    private ReflectionHelper reflectionHelper;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.reflectionHelper = new ReflectionHelper();
        Field a = SimpleBaseDomain.class.getDeclaredField("a");
        Field b = SimpleExtendedDomain.class.getDeclaredField("b");
        Field c = SimpleExtendedDomain.class.getDeclaredField("c");
        Field i = SimpleExtendedDomain.class.getDeclaredField("i");
        this.reflectionHelper.makeAccessible(a);
        this.reflectionHelper.makeAccessible(c);
        this.reflectionHelper.makeAccessible(i);
        SimpleSyntheticField sa = new SimpleSyntheticField(a);
        SimpleSyntheticField sb = new SimpleSyntheticField(b);
        SimpleSyntheticField sc = new SimpleSyntheticField(c);
        SimpleSyntheticField si = new SimpleSyntheticField(i);
        this.toDomainConverter = new ToDomainConverter((SyntheticField)sa, new SyntheticField[]{sc}, (TypeConverter)new NoConversionTypeConverter());
        this.toDomainConverterAccess = new ToDomainConverter((SyntheticField)sa, new SyntheticField[]{sb}, (TypeConverter)new NoConversionTypeConverter());
        this.toDomainConverterArgument = new ToDomainConverter((SyntheticField)sa, new SyntheticField[]{si}, (TypeConverter)new NoConversionTypeConverter());
    }

    @Test
    public void testConvert() throws Exception {
        SimpleExtendedDomain sed = new SimpleExtendedDomain();
        sed.setA(A_VALUE);
        this.toDomainConverter.convert((Object)sed, (Object)sed, new String[0]);
        Assertions.assertThat((String)sed.getC()).isEqualTo((Object)A_VALUE);
    }

    @Test
    public void testConvertIllegalAccessException() throws Exception {
        SimpleExtendedDomain sed = new SimpleExtendedDomain();
        sed.setA(A_VALUE);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot convert TO field a to domain field b, field cannot be accessed.");
        this.toDomainConverterAccess.convert((Object)sed, (Object)sed, new String[0]);
    }

    @Test
    public void testConvertIllegalArgumentException() throws Exception {
        SimpleExtendedDomain sed = new SimpleExtendedDomain();
        sed.setA(A_VALUE);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot convert TO field a to domain field i, field needs type conversion.");
        this.toDomainConverterArgument.convert((Object)sed, (Object)sed, new String[0]);
    }

    @Test
    public void testTransitiveNullException() throws Exception {
        Field addressId = PersonTransitiveTo.class.getDeclaredField("addressId");
        Field address = PersonDomain.class.getDeclaredField("address");
        Field id = AddressDomain.class.getDeclaredField("id");
        this.reflectionHelper.makeAccessible(addressId);
        this.reflectionHelper.makeAccessible(address);
        this.reflectionHelper.makeAccessible(id);
        SimpleSyntheticField sAddress = new SimpleSyntheticField(address);
        SimpleSyntheticField sId = new SimpleSyntheticField(id);
        this.toDomainConverter = new ToDomainConverter((SyntheticField)new SimpleSyntheticField(addressId), new SyntheticField[]{sAddress, sId}, (TypeConverter)new NoConversionTypeConverter());
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot convert TO field addressId to domain field id (with path address), transitive field address in path is null.");
        this.toDomainConverter.convert((Object)new PersonTransitiveTo(), (Object)new PersonDomain(), new String[0]);
    }
}

