/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.assertj.core.api.Assertions;
import org.jtransfo.Converter;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.JTransfoImpl;
import org.jtransfo.ToConverter;
import org.jtransfo.internal.ConverterHelper;
import org.jtransfo.object.SimpleClassDomain;
import org.jtransfo.object.SimpleClassNameTo;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.test.util.ReflectionTestUtils;

public class JTransfoSimpleTest {
    private static final String BLA = "something";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private JTransfo jTransfo;

    @Before
    public void setup() {
        this.jTransfo = new JTransfoImpl();
        ConverterHelper converterHelper = new ConverterHelper(){

            public ToConverter getToConverter(Class toClass, Class domainClass) {
                ToConverter converter = new ToConverter();
                converter.addToTo(new Converter(){

                    public void convert(Object source, Object target, String ... tags) {
                        ((SimpleClassNameTo)target).setBla(((SimpleClassDomain)source).getBla());
                    }
                });
                converter.addToDomain(new Converter(){

                    public void convert(Object source, Object target, String ... tags) {
                        ((SimpleClassDomain)target).setBla(((SimpleClassNameTo)source).getBla());
                    }
                });
                return converter;
            }
        };
        ReflectionTestUtils.setField((Object)this.jTransfo, (String)"converterHelper", (Object)converterHelper);
    }

    @Test
    public void testConvertDomainToTo() throws Exception {
        SimpleClassDomain source = new SimpleClassDomain();
        source.setBla(BLA);
        SimpleClassNameTo result = (SimpleClassNameTo)this.jTransfo.convert((Object)source, (Object)new SimpleClassNameTo(), new String[0]);
        Assertions.assertThat((Object)result).isInstanceOf(SimpleClassNameTo.class);
        Assertions.assertThat((String)result.getBla()).isEqualTo((Object)BLA);
    }

    @Test
    public void testConvertToToDomain() throws Exception {
        SimpleClassNameTo source = new SimpleClassNameTo();
        source.setBla(BLA);
        SimpleClassDomain result = (SimpleClassDomain)this.jTransfo.convert((Object)source, (Object)new SimpleClassDomain(), new String[0]);
        Assertions.assertThat((Object)result).isInstanceOf(SimpleClassDomain.class);
        Assertions.assertThat((String)result.getBla()).isEqualTo((Object)BLA);
    }

    @Test
    public void testConvertSourceOnly() throws Exception {
        SimpleClassNameTo source = new SimpleClassNameTo();
        source.setBla(BLA);
        Object result = this.jTransfo.convert((Object)source);
        Assertions.assertThat((Object)result).isInstanceOf(SimpleClassDomain.class);
        Assertions.assertThat((String)((SimpleClassDomain)result).getBla()).isEqualTo((Object)BLA);
    }

    @Test
    public void testConvertNullLeft() throws Exception {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Source and target are required to be not-null.");
        this.jTransfo.convert(null, (Object)new SimpleClassNameTo(), new String[0]);
    }

    @Test
    public void testConvertNullRight() throws Exception {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Source and target are required to be not-null.");
        this.jTransfo.convert((Object)new SimpleClassDomain(), null, new String[0]);
    }

    @Test
    public void testConvertNeedsTo() throws Exception {
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Neither source nor target are annotated with DomainClass on classes java.lang.Integer and java.lang.Double.");
        this.jTransfo.convert((Object)1, (Object)1.0, new String[0]);
    }
}

