/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoImpl;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.PersonDomain;
import org.jtransfo.object.PersonTransitiveTo;
import org.junit.Before;
import org.junit.Test;

public class TransitiveFieldTest {
    private static final String NAME = "ikke";
    private JTransfo jTransfo;

    @Before
    public void setup() throws Exception {
        this.jTransfo = new JTransfoImpl();
    }

    @Test
    public void testTransitiveToDomain() throws Exception {
        PersonTransitiveTo to = new PersonTransitiveTo();
        to.setName(NAME);
        to.setAddressId(3L);
        to.setAddress("Address 3");
        PersonDomain domain = new PersonDomain();
        domain.setAddress(new AddressDomain());
        domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)domain, new String[0]);
        Assertions.assertThat((String)domain.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(3L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNotNull();
        Assertions.assertThat((Long)domain.getAddress().getId()).isEqualTo(3L);
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Address 3");
    }

    @Test
    public void testTransitiveToTo() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName(NAME);
        Date now = new Date();
        AddressDomain address = new AddressDomain();
        address.setId(7L);
        address.setAddress("Kerkstraat");
        domain.setAddress(address);
        PersonTransitiveTo to = (PersonTransitiveTo)this.jTransfo.convert((Object)domain, (Object)new PersonTransitiveTo(), new String[0]);
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Long)to.getAddressId()).isEqualTo(7L);
        Assertions.assertThat((String)to.getAddress()).isEqualTo((Object)"Kerkstraat");
    }

    @Test
    public void testTransitiveNullToTo() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName(NAME);
        Date now = new Date();
        PersonTransitiveTo to = (PersonTransitiveTo)this.jTransfo.convert((Object)domain, (Object)new PersonTransitiveTo(), new String[0]);
        Assertions.assertThat((String)to.getName()).isEqualTo((Object)NAME);
        Assertions.assertThat((Long)to.getAddressId()).isNull();
        Assertions.assertThat((String)to.getAddress()).isNull();
    }
}

