/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jtransfo.JTransfoException;
import org.jtransfo.MapOnly;
import org.jtransfo.MappedBy;
import org.jtransfo.Named;
import org.jtransfo.NoConversionTypeConverter;
import org.jtransfo.ToConverter;
import org.jtransfo.TypeConverter;
import org.jtransfo.internal.ConverterHelper;
import org.jtransfo.internal.LockableList;
import org.jtransfo.internal.ReflectionHelper;
import org.jtransfo.internal.SimpleSyntheticField;
import org.jtransfo.internal.SyntheticField;
import org.jtransfo.internal.TaggedConverter;
import org.jtransfo.internal.ToDomainConverter;
import org.jtransfo.internal.ToToConverter;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.FaultyExtendedTo;
import org.jtransfo.object.PersonDomain;
import org.jtransfo.object.PersonTransitiveTo;
import org.jtransfo.object.SimpleExtendedDomain;
import org.jtransfo.object.SimpleExtendedTo;
import org.jtransfo.object.TaggedPersonTo;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.test.util.ReflectionTestUtils;

public class ConverterHelperTest {
    private ConverterHelper converterHelper;
    @Mock
    private ReflectionHelper reflectionHelper;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.converterHelper = new ConverterHelper();
        ReflectionTestUtils.setField((Object)this.converterHelper, (String)"reflectionHelper", (Object)this.reflectionHelper);
    }

    @Test
    public void testFindField() throws Exception {
        ArrayList<SimpleSyntheticField> fields = new ArrayList<SimpleSyntheticField>();
        SimpleSyntheticField f1 = new SimpleSyntheticField(SimpleExtendedDomain.class.getDeclaredField("b"));
        SimpleSyntheticField f2 = new SimpleSyntheticField(SimpleExtendedDomain.class.getDeclaredField("c"));
        fields.add(f1);
        fields.add(f2);
        SyntheticField[] res = this.converterHelper.findField(fields, "c", new String[0], SimpleExtendedDomain.class, false);
        Assertions.assertThat((Object)res[0]).isEqualTo((Object)f2);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot find getter from [getBla, isBla, hasBla] on class org.jtransfo.object.SimpleExtendedDomain.");
        this.converterHelper.findField(fields, "bla", new String[0], SimpleExtendedDomain.class, false);
    }

    @Test
    public void testFindFieldTransitive() throws Exception {
        ArrayList<SimpleSyntheticField> fields = new ArrayList<SimpleSyntheticField>();
        SimpleSyntheticField f1 = new SimpleSyntheticField(PersonDomain.class.getDeclaredField("name"));
        SimpleSyntheticField f2 = new SimpleSyntheticField(PersonDomain.class.getDeclaredField("address"));
        fields.add(f1);
        fields.add(f2);
        SimpleSyntheticField f3 = new SimpleSyntheticField(AddressDomain.class.getDeclaredField("id"));
        Mockito.when((Object)this.reflectionHelper.getSyntheticFields((Class)Matchers.any(Class.class))).thenReturn(Collections.singletonList(f3));
        Object[] res = this.converterHelper.findField(fields, "id", new String[]{"address"}, PersonDomain.class, false);
        Assertions.assertThat((Object[])res).hasSize(2);
        Assertions.assertThat((Object)res[0]).isEqualTo((Object)f2);
        Assertions.assertThat((Object)res[1]).isEqualTo((Object)f3);
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot find getter from [getBla, isBla, hasBla] on class org.jtransfo.object.PersonDomain.");
        this.converterHelper.findField(fields, "id", new String[]{"bla"}, PersonDomain.class, false);
    }

    @Test
    public void testGetDeclaredTypeConverterNull() throws Exception {
        Assertions.assertThat((Object)this.converterHelper.getDeclaredTypeConverter(null)).isNull();
    }

    @Test
    public void testGetDeclaredTypeConverterDefaults() throws Exception {
        MappedBy mappedBy = (MappedBy)Mockito.mock(MappedBy.class);
        Mockito.when((Object)mappedBy.typeConverterClass()).thenReturn(MappedBy.DefaultTypeConverter.class);
        Mockito.when((Object)mappedBy.typeConverter()).thenReturn((Object)"?");
        Mockito.when((Object)mappedBy.field()).thenReturn((Object)"?");
        Assertions.assertThat((Object)this.converterHelper.getDeclaredTypeConverter(mappedBy)).isNull();
    }

    @Test
    public void testGetDeclaredTypeConverterAsClass() throws Exception {
        MappedBy mappedBy = (MappedBy)Mockito.mock(MappedBy.class);
        Mockito.when((Object)mappedBy.typeConverterClass()).thenReturn(NoConversionTypeConverter.class);
        Mockito.when((Object)mappedBy.typeConverter()).thenReturn((Object)"?");
        Mockito.when((Object)mappedBy.field()).thenReturn((Object)"?");
        Mockito.when((Object)this.reflectionHelper.newInstance(NoConversionTypeConverter.class.getName())).thenReturn((Object)new NoConversionTypeConverter());
        TypeConverter res = this.converterHelper.getDeclaredTypeConverter(mappedBy);
        Assertions.assertThat((Object)res).isInstanceOf(NoConversionTypeConverter.class);
        TypeConverter res2 = this.converterHelper.getDeclaredTypeConverter(mappedBy);
        Assertions.assertThat((res2 == res ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testGetDeclaredTypeConverterAsName() throws Exception {
        MappedBy mappedBy = (MappedBy)Mockito.mock(MappedBy.class);
        Mockito.when((Object)mappedBy.typeConverterClass()).thenReturn(MappedBy.DefaultTypeConverter.class);
        Mockito.when((Object)mappedBy.typeConverter()).thenReturn((Object)NoConversionTypeConverter.class.getName());
        Mockito.when((Object)mappedBy.field()).thenReturn((Object)"?");
        Mockito.when((Object)this.reflectionHelper.newInstance(NoConversionTypeConverter.class.getName())).thenReturn((Object)new NoConversionTypeConverter());
        TypeConverter res = this.converterHelper.getDeclaredTypeConverter(mappedBy);
        Assertions.assertThat((Object)res).isInstanceOf(NoConversionTypeConverter.class);
    }

    @Test
    public void testGetDeclaredTypeConverterCnfe() throws Exception {
        MappedBy mappedBy = (MappedBy)Mockito.mock(MappedBy.class);
        Mockito.when((Object)mappedBy.typeConverterClass()).thenReturn(MappedBy.DefaultTypeConverter.class);
        Mockito.when((Object)mappedBy.typeConverter()).thenReturn((Object)NoConversionTypeConverter.class.getName());
        Mockito.when((Object)mappedBy.field()).thenReturn((Object)"?");
        Mockito.when((Object)this.reflectionHelper.newInstance(NoConversionTypeConverter.class.getName())).thenThrow(new Throwable[]{new ClassNotFoundException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Declared TypeConverter class org.jtransfo.NoConversionTypeConverter cannot be found.");
        this.converterHelper.getDeclaredTypeConverter(mappedBy);
    }

    @Test
    public void testGetDeclaredTypeConverterIe() throws Exception {
        MappedBy mappedBy = (MappedBy)Mockito.mock(MappedBy.class);
        Mockito.when((Object)mappedBy.typeConverterClass()).thenReturn(MappedBy.DefaultTypeConverter.class);
        Mockito.when((Object)mappedBy.typeConverter()).thenReturn((Object)NoConversionTypeConverter.class.getName());
        Mockito.when((Object)mappedBy.field()).thenReturn((Object)"?");
        Mockito.when((Object)this.reflectionHelper.newInstance(NoConversionTypeConverter.class.getName())).thenThrow(new Throwable[]{new InstantiationException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Declared TypeConverter class org.jtransfo.NoConversionTypeConverter cannot be instantiated.");
        this.converterHelper.getDeclaredTypeConverter(mappedBy);
    }

    @Test
    public void testGetDeclaredTypeConverterIae() throws Exception {
        MappedBy mappedBy = (MappedBy)Mockito.mock(MappedBy.class);
        Mockito.when((Object)mappedBy.typeConverterClass()).thenReturn(MappedBy.DefaultTypeConverter.class);
        Mockito.when((Object)mappedBy.typeConverter()).thenReturn((Object)NoConversionTypeConverter.class.getName());
        Mockito.when((Object)mappedBy.field()).thenReturn((Object)"?");
        Mockito.when((Object)this.reflectionHelper.newInstance(NoConversionTypeConverter.class.getName())).thenThrow(new Throwable[]{new IllegalAccessException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Declared TypeConverter class org.jtransfo.NoConversionTypeConverter cannot be accessed.");
        this.converterHelper.getDeclaredTypeConverter(mappedBy);
    }

    @Test
    public void testGetDeclaredTypeConverterCce() throws Exception {
        MappedBy mappedBy = (MappedBy)Mockito.mock(MappedBy.class);
        Mockito.when((Object)mappedBy.typeConverterClass()).thenReturn(MappedBy.DefaultTypeConverter.class);
        Mockito.when((Object)mappedBy.typeConverter()).thenReturn((Object)NoConversionTypeConverter.class.getName());
        Mockito.when((Object)mappedBy.field()).thenReturn((Object)"?");
        Mockito.when((Object)this.reflectionHelper.newInstance(NoConversionTypeConverter.class.getName())).thenThrow(new Throwable[]{new ClassCastException()});
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Declared TypeConverter class org.jtransfo.NoConversionTypeConverter cannot be cast to a TypeConverter.");
        this.converterHelper.getDeclaredTypeConverter(mappedBy);
    }

    @Test
    public void testGetDefaultTypeConverterEmptyList() throws Exception {
        TypeConverter typeConverter = this.converterHelper.getDefaultTypeConverter(Object.class, Date.class);
        Assertions.assertThat((Object)typeConverter).isInstanceOf(NoConversionTypeConverter.class);
    }

    @Test
    public void testGetDefaultTypeConverterMatchingConverter() throws Exception {
        TypeConverter typeConverter = (TypeConverter)Mockito.mock(TypeConverter.class);
        Mockito.when((Object)typeConverter.canConvert((Class)Matchers.any(Class.class), (Class)Matchers.any(Class.class))).thenReturn((Object)true);
        ReflectionTestUtils.setField((Object)this.converterHelper, (String)"typeConvertersInOrder", Collections.singletonList(typeConverter));
        TypeConverter result = this.converterHelper.getDefaultTypeConverter(Object.class, Date.class);
        Assertions.assertThat((Object)result).isEqualTo((Object)typeConverter);
    }

    @Test
    public void testGetDefaultTypeConverterNoMatchingConverter() throws Exception {
        ArrayList<DefaultTypeConverter> tcs = new ArrayList<DefaultTypeConverter>();
        tcs.add(new DefaultTypeConverter());
        tcs.add(new DefaultTypeConverter());
        ReflectionTestUtils.setField((Object)this.converterHelper, (String)"typeConvertersInOrder", tcs);
        TypeConverter typeConverter = this.converterHelper.getDefaultTypeConverter(Object.class, Date.class);
        Assertions.assertThat((Object)typeConverter).isInstanceOf(NoConversionTypeConverter.class);
    }

    @Test
    public void testGetToConverter() throws Exception {
        ReflectionTestUtils.setField((Object)this.converterHelper, (String)"reflectionHelper", (Object)new ReflectionHelper());
        ToConverter res = this.converterHelper.getToConverter(SimpleExtendedTo.class, SimpleExtendedDomain.class);
        Assertions.assertThat((Object)res).isNotNull();
        Assertions.assertThat((List)res.getToTo()).hasSize(4);
        Assertions.assertThat(res.getToTo().get(0)).isInstanceOf(ToToConverter.class);
        Assertions.assertThat((List)res.getToDomain()).hasSize(3);
        Assertions.assertThat(res.getToDomain().get(0)).isInstanceOf(ToDomainConverter.class);
    }

    @Test
    public void testGetToConverter_mapOnly() throws Exception {
        ReflectionTestUtils.setField((Object)this.converterHelper, (String)"reflectionHelper", (Object)new ReflectionHelper());
        ((Map)ReflectionTestUtils.getField((Object)this.converterHelper, (String)"typeConverterInstances")).put("always2", new DefaultTypeConverter());
        ToConverter res = this.converterHelper.getToConverter(TaggedPersonTo.class, PersonDomain.class);
        Assertions.assertThat((Object)res).isNotNull();
        Assertions.assertThat((List)res.getToTo()).hasSize(4);
        Assertions.assertThat(res.getToTo().get(0)).isInstanceOf(TaggedConverter.class);
        Assertions.assertThat((List)res.getToDomain()).hasSize(3);
        Assertions.assertThat(res.getToDomain().get(0)).isInstanceOf(TaggedConverter.class);
    }

    @Test
    public void testGetToConverterTransitive() throws Exception {
        ReflectionTestUtils.setField((Object)this.converterHelper, (String)"reflectionHelper", (Object)new ReflectionHelper());
        ToConverter res = this.converterHelper.getToConverter(PersonTransitiveTo.class, PersonDomain.class);
        Assertions.assertThat((Object)res).isNotNull();
        Assertions.assertThat((List)res.getToTo()).hasSize(3);
        Assertions.assertThat((List)res.getToDomain()).hasSize(3);
    }

    @Test
    public void testGetToConverterInvalidMapping() throws Exception {
        ReflectionTestUtils.setField((Object)this.converterHelper, (String)"reflectionHelper", (Object)new ReflectionHelper());
        this.exception.expect(JTransfoException.class);
        this.exception.expectMessage("Cannot determine mapping for field string in class org.jtransfo.object.FaultyExtendedTo. The field zzz in class org.jtransfo.object.SimpleExtendedDomain cannot be found.");
        this.converterHelper.getToConverter(FaultyExtendedTo.class, SimpleExtendedDomain.class);
    }

    @Test
    public void testSetTypeConvertersInOrder() throws Exception {
        List org = (List)ReflectionTestUtils.getField((Object)this.converterHelper, (String)"typeConvertersInOrder");
        TypeConverter typeConverter = (TypeConverter)Mockito.mock(TypeConverter.class);
        Assertions.assertThat((int)org.size()).isEqualTo(0);
        this.converterHelper.setTypeConvertersInOrder(Collections.singletonList(typeConverter));
        List res = (List)ReflectionTestUtils.getField((Object)this.converterHelper, (String)"typeConvertersInOrder");
        Assertions.assertThat((int)res.size()).isEqualTo(1);
        Assertions.assertThat((Object)res).isInstanceOf(LockableList.class);
        Assertions.assertThat((Boolean)((Boolean)ReflectionTestUtils.getField((Object)res, (String)"readOnly"))).isTrue();
    }

    @Test
    public void testSetTypeConvertersInOrderNamed() throws Exception {
        List org = (List)ReflectionTestUtils.getField((Object)this.converterHelper, (String)"typeConvertersInOrder");
        NamedTypeConverter typeConverter = (NamedTypeConverter)Mockito.mock(NamedTypeConverter.class);
        Assertions.assertThat((int)org.size()).isEqualTo(0);
        this.converterHelper.setTypeConvertersInOrder(Collections.singletonList(typeConverter));
        List res = (List)ReflectionTestUtils.getField((Object)this.converterHelper, (String)"typeConvertersInOrder");
        Assertions.assertThat((int)res.size()).isEqualTo(1);
        Assertions.assertThat((Object)res).isInstanceOf(LockableList.class);
        Assertions.assertThat((Boolean)((Boolean)ReflectionTestUtils.getField((Object)res, (String)"readOnly"))).isTrue();
        ((NamedTypeConverter)Mockito.verify((Object)typeConverter)).getName();
    }

    @Test
    public void testWithPath() throws Exception {
        Assertions.assertThat((String)this.converterHelper.withPath(new String[]{"parts", "to", "add"})).isEqualTo((Object)" (with path parts.to.add) ");
    }

    @Test
    public void testGetDeclaredTypeConverter() throws Exception {
        MapOnly mapOnly = (MapOnly)Mockito.mock(MapOnly.class);
        Mockito.when((Object)mapOnly.typeConverterClass()).thenReturn(MappedBy.DefaultTypeConverter.class);
        Mockito.when((Object)mapOnly.typeConverter()).thenReturn((Object)"?");
        TypeConverter tc = (TypeConverter)Mockito.mock(TypeConverter.class);
        TypeConverter res = this.converterHelper.getDeclaredTypeConverter(mapOnly, tc);
        Assertions.assertThat((Object)res).isEqualTo((Object)tc);
    }

    @Test
    public void testGetDeclaredTypeConverter_withTypeConverter() throws Exception {
        MapOnly mapOnly = (MapOnly)Mockito.mock(MapOnly.class);
        Mockito.when((Object)this.reflectionHelper.newInstance("org.jtransfo.internal.ConverterHelperTest$DefaultTypeConverter")).thenReturn((Object)new DefaultTypeConverter());
        Mockito.when((Object)mapOnly.typeConverterClass()).thenReturn(DefaultTypeConverter.class);
        Mockito.when((Object)mapOnly.typeConverter()).thenReturn((Object)"?");
        TypeConverter tc = (TypeConverter)Mockito.mock(TypeConverter.class);
        TypeConverter res = this.converterHelper.getDeclaredTypeConverter(mapOnly, tc);
        Assertions.assertThat((Object)res).isInstanceOf(DefaultTypeConverter.class);
    }

    @Test
    public void testGetMapOnlies_both() throws Exception {
        Field field = TaggedPersonTo.class.getDeclaredField("gender");
        field.setAccessible(true);
        List res = this.converterHelper.getMapOnlies(field);
        Assertions.assertThat((List)res).hasSize(2);
    }

    @Test
    public void testGetMapOnlies_mapOnlies() throws Exception {
        Field field = TaggedPersonTo.class.getDeclaredField("name");
        field.setAccessible(true);
        List res = this.converterHelper.getMapOnlies(field);
        Assertions.assertThat((List)res).hasSize(2);
    }

    @Test
    public void testGetMapOnlies_none() throws Exception {
        Field field = TaggedPersonTo.class.getDeclaredField("lastChanged");
        field.setAccessible(true);
        List res = this.converterHelper.getMapOnlies(field);
        Assertions.assertThat((List)res).isNull();
    }

    @Test
    public void testGetDeclaredTypeConverter_null() throws Exception {
        TypeConverter tc = (TypeConverter)Mockito.mock(TypeConverter.class);
        TypeConverter res = this.converterHelper.getDeclaredTypeConverter(null, tc);
        Assertions.assertThat((Object)res).isEqualTo((Object)tc);
    }

    private static interface NamedTypeConverter
    extends TypeConverter,
    Named {
    }

    private class DefaultTypeConverter
    implements TypeConverter<Object, Object> {
        private DefaultTypeConverter() {
        }

        public boolean canConvert(Class<?> realToType, Class<?> realDomainType) {
            return false;
        }

        public Object convert(Object object, SyntheticField domainField, Object domainObject, String ... tags) throws JTransfoException {
            return null;
        }

        public Object reverse(Object object, SyntheticField toField, Object toObject, String ... tags) throws JTransfoException {
            return null;
        }
    }
}

