/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo.internal;

import org.jtransfo.Converter;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.SyntheticField;

public abstract class AbstractConverter
implements Converter {
    public abstract void doConvert(Object var1, Object var2, String ... var3) throws JTransfoException, IllegalAccessException, IllegalArgumentException;

    public abstract String accessExceptionMessage();

    public abstract String argumentExceptionMessage();

    @Override
    public void convert(Object source, Object target, String ... tags) throws JTransfoException {
        try {
            this.doConvert(source, target, tags);
        }
        catch (IllegalAccessException iae) {
            throw new JTransfoException(this.accessExceptionMessage(), iae);
        }
        catch (IllegalArgumentException iae) {
            String throwingClass;
            if (null != iae.getStackTrace() && iae.getStackTrace().length > 0 && (throwingClass = iae.getStackTrace()[0].getClassName()).startsWith("sun.reflect.")) {
                throw new JTransfoException(this.argumentExceptionMessage(), iae);
            }
            throw iae;
        }
    }

    protected String domainFieldName(SyntheticField[] domainFields) {
        StringBuilder sb = new StringBuilder();
        if (domainFields.length > 0) {
            sb.append(domainFields[domainFields.length - 1].getName());
            if (domainFields.length > 1) {
                sb.append(" (with path ");
                for (int i = 0; i < domainFields.length - 2; ++i) {
                    sb.append(domainFields[i].getName());
                    sb.append(".");
                }
                sb.append(domainFields[domainFields.length - 2].getName());
                sb.append(")");
            }
        }
        return sb.toString();
    }
}

