/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import org.assertj.core.api.Assertions;
import org.jtransfo.AutomaticStringEnumTypeConverter;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoImpl;
import org.jtransfo.object.AddressDomain;
import org.jtransfo.object.Gender;
import org.jtransfo.object.PersonDomain;
import org.jtransfo.object.SecretsTo;
import org.junit.Before;
import org.junit.Test;

public class ConvertWithTagsDifferentFieldsTest {
    private JTransfo jTransfo;

    @Before
    public void setup() throws Exception {
        JTransfoImpl impl = new JTransfoImpl();
        this.jTransfo = impl;
        impl.getTypeConverters().add(new AutomaticStringEnumTypeConverter());
        impl.updateTypeConverters();
    }

    @Test
    public void testConverterToDomain() throws Exception {
        SecretsTo to = new SecretsTo();
        to.setAddressOrName("Kerkstraat");
        to.setGenderOrName(Gender.FEMALE.name());
        PersonDomain domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)this.personDomainWithAddress(), new String[]{"zzz"});
        Assertions.assertThat((String)domain.getName()).isNull();
        Assertions.assertThat((Object)((Object)domain.getGender())).isEqualTo((Object)Gender.FEMALE);
        Assertions.assertThat((Long)domain.getAddress().getId()).isNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNull();
        domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)this.personDomainWithAddress(), new String[]{"name"});
        Assertions.assertThat((String)domain.getName()).isEqualTo((Object)"Kerkstraat");
        Assertions.assertThat((Object)((Object)domain.getGender())).isEqualTo((Object)Gender.FEMALE);
        Assertions.assertThat((Long)domain.getAddress().getId()).isNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isNull();
        domain = (PersonDomain)this.jTransfo.convert((Object)to, (Object)this.personDomainWithAddress(), new String[]{"address"});
        Assertions.assertThat((String)domain.getName()).isNull();
        Assertions.assertThat((Object)((Object)domain.getGender())).isEqualTo((Object)Gender.FEMALE);
        Assertions.assertThat((Long)domain.getAddress().getId()).isNull();
        Assertions.assertThat((String)domain.getAddress().getAddress()).isEqualTo((Object)"Kerkstraat");
    }

    @Test
    public void testConverterToTo() throws Exception {
        PersonDomain domain = new PersonDomain();
        domain.setName("Joske");
        domain.setGender(Gender.MALE);
        AddressDomain address = new AddressDomain();
        address.setId(7L);
        address.setAddress("Kerkstraat");
        domain.setAddress(address);
        SecretsTo to = (SecretsTo)this.jTransfo.convert((Object)domain, (Object)new SecretsTo(), new String[]{"zzz"});
        Assertions.assertThat((String)to.getAddressOrName()).isNull();
        Assertions.assertThat((String)to.getGenderOrName()).isEqualTo((Object)"MALE");
        to = (SecretsTo)this.jTransfo.convert((Object)domain, (Object)new SecretsTo(), new String[]{"name"});
        Assertions.assertThat((String)to.getAddressOrName()).isEqualTo((Object)"Joske");
        Assertions.assertThat((String)to.getGenderOrName()).isEqualTo((Object)"Joske");
        to = (SecretsTo)this.jTransfo.convert((Object)domain, (Object)new SecretsTo(), new String[]{"address"});
        Assertions.assertThat((String)to.getAddressOrName()).isEqualTo((Object)"Kerkstraat");
        Assertions.assertThat((String)to.getGenderOrName()).isEqualTo((Object)"MALE");
    }

    private PersonDomain personDomainWithAddress() {
        PersonDomain res = new PersonDomain();
        res.setAddress(new AddressDomain());
        return res;
    }
}

