/*
 * Decompiled with CFR 0.152.
 */
package org.jtransfo;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.jtransfo.AbstractListTypeConverter;
import org.jtransfo.JTransfo;
import org.jtransfo.JTransfoException;
import org.jtransfo.internal.SyntheticField;

public class AutomaticListTypeConverter
extends AbstractListTypeConverter {
    private static final String NAME = "automaticList";

    public AutomaticListTypeConverter() {
        super(NAME, Object.class);
    }

    public AutomaticListTypeConverter(String name) {
        super(name, Object.class);
    }

    public AutomaticListTypeConverter(JTransfo jTransfo) {
        super(NAME, Object.class);
        super.setJTransfo(jTransfo);
    }

    @Override
    public boolean canConvert(Type realToType, Type realDomainType) {
        Class<?> toClass = this.getClass(realToType);
        Class<?> domainClass = this.getClass(realDomainType);
        if (!List.class.isAssignableFrom(toClass) || !List.class.isAssignableFrom(domainClass)) {
            return false;
        }
        Class<?> paramRealToType = this.getParamType(realToType);
        Class<?> paramRealDomainType = this.getParamType(realDomainType);
        if (paramRealToType == null || paramRealDomainType == null) {
            return false;
        }
        return this.getJTransfo().isToClass(paramRealToType) && paramRealDomainType.isAssignableFrom(this.getJTransfo().getDomainClass(paramRealToType));
    }

    @Override
    public Object doConvertOne(JTransfo jTransfo, Object toObject, Class<?> domainObjectType, String ... tags) throws JTransfoException {
        return jTransfo.convertTo(toObject, domainObjectType, tags);
    }

    @Override
    public Object doReverseOne(JTransfo jTransfo, Object domainObject, SyntheticField toField, Class<?> toType, String ... tags) throws JTransfoException {
        Class<?> clazz = this.getParamType(toField.getGenericType());
        return jTransfo.convertTo(domainObject, jTransfo.getToSubType(clazz, domainObject), tags);
    }

    private Class<?> getClass(Type type) {
        return type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
    }

    private Class<?> getParamType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return (Class)p.getActualTypeArguments()[0];
        }
        return null;
    }
}

